% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaTest.R
\name{test.BE}
\alias{test.BE}
\title{The Betsch-Ebner goodness-of-fit test for the gamma family}
\usage{
test.BE(data, a = 1, boot = 500, alpha = 0.05)
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{a}{positive tuning parameter.}

\item{boot}{number of bootstrap iterations used to obtain critical value.}

\item{alpha}{level of significance of the test.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$T.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$par.est}}{number of points used in approximation.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
        \item{\code{$sig.level}}{level of significance chosen.}
        \item{\code{$boot.run}}{number of bootstrap iterations.}
}
}
\description{
This function computes the goodness-of-fit test for the gamma family due to Betsch and Ebner (2019).
}
\details{
The test is of weighted \eqn{L^2} type and uses a characterization of the distribution function of the gamma distribution. Critical values are obtained by a parametric bootstrap procedure, see \code{\link{crit.values}}.
}
\examples{
test.BE(stats::rgamma(20,3,6),boot=100)

}
\references{
Betsch, S., Ebner, B. (2019) "A new characterization of the Gamma distribution and associated goodness of fit tests", Metrika, 82(7):779-806. \href{https://doi.org/10.1007/s00184-019-00708-7}{DOI}
}
