% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_google_vision_response.R
\name{gcv_get_image_annotations}
\alias{gcv_get_image_annotations}
\title{Get parsed image annotations from the Google Cloud Vision API}
\usage{
gcv_get_image_annotations(imagePaths, feature = "LABEL_DETECTION",
  maxNumResults = NULL, batchSize = 64L, savePath = NULL)
}
\arguments{
\item{imagePaths}{character, file paths, URLs or Cloud Storage URIs of the images,
can be a combination of all three}

\item{feature}{character, one out of: "LABEL_DETECTION", "FACE_DETECTION",
"TEXT_DETECTION", "DOCUMENT_TEXT_DETECTION", "LOGO_DETECTION", "LANDMARK_DETECTION"}

\item{maxNumResults}{integer, the maximum number of results (per image) to be returned.}

\item{batchSize}{integer, the chunk size for batch processing}

\item{savePath}{character, if specified, results will be saved to this path (as .csv)}
}
\value{
a data frame with image annotation results
}
\description{
Given a list of images, a feature type and the maximum number of responses,
  this functions calls the Google Cloud Vision API, and returns the image annotations in a data.table format.
}
\examples{
\dontrun{
    # Label Detection (default), with maximum 7 results returned per image
    imagePath <- system.file(
      "extdata", "golden_retriever_puppies.jpg", package = "googleCloudVisionR"
    )
    gcv_get_image_annotations(imagePaths = imagePath, maxNumResults = 7)

    # Face detection
    imagePath <- system.file(
      "extdata", "arnold_wife.jpg", package = "googleCloudVisionR"
    )
    gcv_get_image_annotations(imagePaths = imagePath, feature = "FACE_DETECTION")

    # Google Cloud Storage URI as input
    gcv_get_image_annotations("gs://vision-api-handwriting-ocr-bucket/handwriting_image.png")
}

}
