% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hero_radspline.R
\name{plot.hero_radspline}
\alias{plot.hero_radspline}
\title{Plot a \code{hero_radspline}}
\usage{
\method{plot}{hero_radspline}(
  x,
  blist = list(col = "grey"),
  glist = list(col = seq_along(x$grid) + 1, pch = seq_along(x$grid)),
  ...
)
}
\arguments{
\item{x}{A \code{hero_radspline} object.}

\item{blist}{A list to pass the plot method associated
with \code{\link[sp]{SpatialPolygons-class}} when
plotting \code{x$border}.  The default is a
grey-colored polygon.}

\item{glist}{A list to pass the plot method associated
with \code{\link[sp]{SpatialPoints-class}} when
plotting each element of the list \code{x$grid}.  A
basic color scheme and point style is automatically
chosen if none is supplied.}

\item{...}{Additional arguments to pass the plot method
associated with \code{\link[sp]{SpatialPolygons-class}}
when plotting \code{x$eborder}.}
}
\description{
Plot a \code{hero_radspline} to compare the knots to the
observed data locations.
}
\details{
If the default plotting styles for \code{x$grid} are to
be changed, the user can either choose a single
color/style that is replicated for each element of
\code{x$grid} or supply a vector which has length
matching \code{length{x$grid}}.  See Examples.
}
\examples{
border = border.grid(lon, lat)
r = radspline(nknots = c(36, 36 * 4), border = border)
# default color scheme
plot(r)
# change color and point styles of points,
# and background of original domain
plot(r, blist = list(col = "yellow"),
        glist = list(col = c("blue", "orange"),
                     pch =  3:4))
}
\seealso{
\code{\link{radspline}}
}
\author{
Joshua French
}
