% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparametric_sdr.R
\name{hier.phd.nt}
\alias{hier.phd.nt}
\title{Main hierarchical SDR fitting function}
\usage{
hier.phd.nt(
  x,
  y,
  z,
  z.combinations,
  d,
  weights = rep(1L, NROW(y)),
  constrain.none.subpop = TRUE,
  pooled = FALSE,
  ...
)
}
\arguments{
\item{x}{an n x p matrix of covariates, where each row is an observation and each column is a predictor}

\item{y}{vector of responses of length n}

\item{z}{an n x C matrix of binary indicators, where each column is a binary variable indicating the presence
of a binary variable which acts as a stratifying variable. Each combination of all columns of \code{z} pertains
to a different subpopulation. WARNING: do not use too many binary variables in \code{z} or else it will quickly
result in subpopulations with no observations}

\item{z.combinations}{a matrix of dimensions 2^C x C with each row indicating a different combination of the possible
values in \code{z}. Each combination represents a subpopulation. This is necessary because we need to specify a
different structural dimension for each subpopulation, so we need to know the ordering of the subpopulations so we
can assign each one a structural dimension}

\item{d}{an integer vector of length 2^C of structural dimensions. Specified in the same order as the rows in
\code{z.combinations}}

\item{weights}{vector of observation weights}

\item{constrain.none.subpop}{should the "none" subpopulation be constrained to be contained in every other subpopulation's
dimension reduction subspace? Recommended to set to \code{TRUE}}

\item{pooled}{should the estimator be a pooled estimator?}

\item{...}{not used}
}
\value{
A list with the following elements
\itemize{
\item beta a list of estimated sufficient dimension reduction matrices, one for each subpopulation
\item directions a list of estimated sufficient dimension reduction directions (i.e. the reduced dimension predictors/variables), one for each subpopulation.
These have number of rows equal to the sample size for the subpopulation and number of columns equal to the specified dimensions of the reduced dimension spaces.
\item y.list a list of vectors of responses for each subpopulation
\item z.combinations the \code{z.combinations} specified as an input
\item cov list of variance covariance matrices for the covariates for each subpopulation
\item sqrt.inv.cov list of inverse square roots of the variance covariance matrices for the covariates for each subpopulation. These are used for scaling
}
}
\description{
fits hierarchical SDR models
}
\examples{

library(hierSDR)

}
