% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data with hierarchical subspaces}
\usage{
simulate_data(
  nobs,
  nvars,
  x.type = c("continuous", "some_categorical"),
  sd.y = 1,
  rho = 0.5,
  model = c("1", "2", "3")
)
}
\arguments{
\item{nobs}{positive integer for the sample size per subpopulation}

\item{nvars}{positive integer for the dimension}

\item{x.type}{variable type for covariates, either \code{"continuous"} (where the covariates are multivariate normal with a variance-matrix
with AR-1 form with parameter \code{rho}) or \code{"some_categorical"} (where half covariates are continuous and
the other half are binary with dependencies on the continuous covariates)}

\item{sd.y}{standard deviation of responsee}

\item{rho}{correlation parameter for AR-1 covariance structure for continuous covariates}

\item{model}{model number used, either "1", "2", or "3", each corresponds to a different outcome model setting}
}
\value{
A list with the following elements
\itemize{
\item x a matrix of covariates with number of rows equal to the total sample size and columns equal to the number of variables
\item z a matrix with number of rows equal to the total sample size and columns as dummy variables indicating presence of a stratifying factor
\item y a vector of all responses
\item beta a list of the true sufficient dimension reduction matrices, one for each subpopulation
\item z.combinations all possible combinations of the stratifying factors \code{z}
\item snr scalar the observed signal-to-noise ratio for the response
\item d.correct the true dimensions of the dimension reduction spaces
}
}
\description{
Simulates data with hierarchical subspaces. Data are generated with two factors that induce heterogeneity
}
\examples{

library(hierSDR)

set.seed(123)
dat <- simulate_data(nobs = 100, nvars = 6,
                     x.type = "some_categorical",
                     sd.y = 1, model = 2)

x <- dat$x ## covariates
z <- dat$z ## factor indicators
y <- dat$y ## response

dat$beta ## true coefficients that generate the subspaces

dat$snr ## signal-to-noise ratio

str(x)
str(z)

dat$z.combinations ## what combinations of z represent different subpops

## correct structural dimensions:
dat$d.correct


}
