% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_hover.R
\name{use_hover}
\alias{use_hover}
\title{Use the hover package}
\usage{
use_hover(popback = FALSE)
}
\arguments{
\item{popback}{If true, buttons 'pop back', contrary to default shiny behavior.}
}
\description{
Enables hover by including the CSS file necessary for the
animations.
}
\details{
By default, shiny buttons don't 'pop back'. This is for accessibility
reasons. For more information see here: https://github.com/rstudio/shiny/issues/2500.
}
\examples{
if (interactive()) {
  library(shiny)
  library(hover)

  ui <- fluidPage(
    use_hover(),
    hover_action_button(
      inputId = "btn",
      label = "hello hover!",
      icon = icon("refresh"),
      button_animation = "rotate",
      icon_animation = "spin"
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
