% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icsPlot.R
\name{icsPlot}
\alias{icsPlot}
\title{Test of Marginal Proportion for Clustered Data}
\usage{
icsPlot(
  x,
  id,
  FUN = c("mean", "median", "var", "sd", "range", "IQR", "prop"),
  breaks,
  xlab = NULL,
  ylab = NULL,
  legend = c(TRUE, FALSE),
  ...
)
}
\arguments{
\item{x}{vector of data values. Alternatively a two-dimensional table or matrix.}

\item{id}{a vector which identifies the clusters, with length equal to length of \code{x}; ignored if \code{x} is a matrix or table.}

\item{FUN}{the name of the function that produces the desired intra-cluster summary statistic.}

\item{breaks}{a single number giving the number of desired quantiles for the barplot of categorical variables with >2 categories.}

\item{xlab}{a label for the x axis, defaults to "cluster size".}

\item{ylab}{a label for the y axis, defaults to a description of \code{FUN} of \code{x}.}

\item{legend}{a logical indicating whether a legend should be included in a barplot.}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Function to visualize informative cluster size. Plots within-cluster summary statistic from
quantitative variables against the size of each cluster. For categorical variables, a barplot of
category proportions for quantiles of cluster size is produced.
}
\details{
If \code{x} is a matrix or table and \code{x} has exactly two columns, the first column should contain the cluster
sizes and the second column the respective intra-cluster summary statistic (e.g., mean, variance) that will be plotted
against cluster size.

If \code{x} has more than two columns, the first column is assumed to contain the cluster size
and the subsequent columns the counts of intra-cluster observations belonging to the different categorical variable levels.
If there are exactly two categorical levels (e.g., \code{x} has exactly three columns), a scatterplot of the proportion of
intracluster observations belonging to the first category will be plotted against the cluster size. If the number of
categories is > 2, a barplot of category proportions against quantiles of cluster size is produced.

Standard graphical parameters can be passed to \code{icsPlot} through the \code{...} argument.
}
\examples{
data(screen8)
## VECTOR INPUT
## plot average math score by cluster size
icsPlot(x = screen8$math, id = screen8$sch.id, pch = 20)

## plot proportion of females by cluster size
icsPlot(screen8$gender, screen8$sch.id, pch = 20, main = "Female proportion by cluster size")

## barchart of activity proportion by quartile of cluster size
icsPlot(x = screen8$activity, id = screen8$sch.id)

## TABLE INPUT
## Plot intra-cluster variance of math score by cluster size
cl.size <- as.numeric(table(screen8$sch.id))
tab1 <- cbind(cl.size, aggregate(screen8$math, list(screen8$sch.id), var)[,2])
colnames(tab1) <- c("cl.size", "variance")
icsPlot(x = tab1, pch = 17, main = "math score variance by cluster size")

## barchart of activity proportion across five quantiles of cluster size
tab2 <- cbind(cl.size, table(screen8$sch.id, screen8$activity))
icsPlot(tab2, breaks = 5)

}
