% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{generate_counts}
\alias{generate_counts}
\title{Generate normal counts}
\usage{
generate_counts(init_pop_size, n_timepoints, overall_prop, mean, sd)
}
\arguments{
\item{init_pop_size}{Initial population size}

\item{n_timepoints}{Number of timepoints}

\item{overall_prop}{Overall proportion of the population to be included in
the counts over all the timepoints}

\item{mean}{Mean of the normal distribution}

\item{sd}{Standard deviation of the normal distribution}
}
\value{
An integer vector of counts of length \code{n_timepoints}
}
\description{
Generates counts from a normal distribution density function.
}
\examples{
# Tokars (2018) vaccinations
vacs_tok <- generate_counts(1e6, 304, 0.55, 100, 50)
# Tokars (2018) cases
casen_tok <- generate_counts(1e6, 304, 0.12, 190, 35)
}
