% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{weighted_kernel_est}
\alias{weighted_kernel_est}
\title{Calculation of weighted nonparametric regression estimate of the dose response function}
\usage{
weighted_kernel_est(A, y, weights, Aseq)
}
\arguments{
\item{A}{vector indicating the value of the treatment or exposure variable. Should be a numeric vector.}

\item{y}{vector of responses}

\item{weights}{a vector of sample weights of length equal to the length of \code{y}}

\item{Aseq}{a vector of new points for which to obtain estimates of E(Y(a))}
}
\value{
A list with the following elements
\item{fit}{A fitted model object from the \code{\link[locfit]{lp}} function}
\item{estimated}{a vector of estimates of a causal ADRF at the values of the treatment specified by \code{Aseq}}
}
\description{
Calculates weighted nonparametric regression estimate of the causal average dose response function
}
