% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_importance.R
\name{plot.feature_importance_explainer}
\alias{plot.feature_importance_explainer}
\title{Plots Feature Importance}
\usage{
\method{plot}{feature_importance_explainer}(
  x,
  ...,
  max_vars = NULL,
  show_boxplots = TRUE,
  bar_width = 10,
  desc_sorting = TRUE,
  title = "Feature Importance",
  subtitle = NULL
)
}
\arguments{
\item{x}{a feature importance explainer produced with the \code{feature_importance()} function}

\item{...}{other explainers that shall be plotted together}

\item{max_vars}{maximum number of variables that shall be presented for for each model.
By default \code{NULL} what means all variables}

\item{show_boxplots}{logical if \code{TRUE} (default) boxplot will be plotted to show permutation data.}

\item{bar_width}{width of bars. By default \code{10}}

\item{desc_sorting}{logical. Should the bars be sorted descending? By default TRUE}

\item{title}{the plot's title, by default \code{'Feature Importance'}}

\item{subtitle}{the plot's subtitle. By default - \code{NULL}, which means
the subtitle will be 'created for the XXX model', where XXX is the label of explainer(s)}
}
\value{
a \code{ggplot2} object
}
\description{
This function plots variable importance calculated as changes in the loss function after variable drops.
It uses output from \code{feature_importance} function that corresponds to
permutation based measure of variable importance.
Variables are sorted in the same order in all panels.
The order depends on the average drop out loss.
In different panels variable contributions may not look like sorted if variable
importance is different in different in different models.
}
\details{
Find more details in the \href{https://ema.drwhy.ai/featureImportance.html}{Feature Importance Chapter}.
}
\examples{
library("DALEX")
library("ingredients")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8])

fi_rf <- feature_importance(explain_titanic_glm, B = 1)
plot(fi_rf)

\donttest{
library("ranger")
model_titanic_rf <- ranger(survived ~., data = titanic_imputed, probability = TRUE)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              label = "ranger forest",
                              verbose = FALSE)

fi_rf <- feature_importance(explain_titanic_rf)
plot(fi_rf)

HR_rf_model <- ranger(status~., data = HR, probability = TRUE)

explainer_rf  <- explain(HR_rf_model, data = HR, y = HR$status,
                         verbose = FALSE, precalculate = FALSE)

fi_rf <- feature_importance(explainer_rf, type = "raw", max_vars = 3,
                            loss_function = DALEX::loss_cross_entropy)
head(fi_rf)
plot(fi_rf)

HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR, y = as.numeric(HR$status == "fired"))

fi_glm <- feature_importance(explainer_glm, type = "raw",
                             loss_function = DALEX::loss_root_mean_square)
head(fi_glm)
plot(fi_glm)
}

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://ema.drwhy.ai/}
}
