% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgx_factors_test.R
\name{FGXFactorsTest}
\alias{FGXFactorsTest}
\title{Testing for the pricing contribution of new factors.}
\usage{
FGXFactorsTest(
  gross_returns,
  control_factors,
  new_factors,
  n_folds = 5,
  check_arguments = TRUE
)
}
\arguments{
\item{gross_returns}{A \verb{n_observations x n_returns}-dimensional matrix of test asset
gross returns.}

\item{control_factors}{A \verb{n_observations x n_control_factors}-dimensional
matrix of control or benchmark factors.}

\item{new_factors}{A \verb{n_observations x n_new_factors}-dimensional
matrix of new factors.}

\item{n_folds}{An integer indicating
the number of k-fold for cross validation. Default is \code{5}.}

\item{check_arguments}{A boolean \code{TRUE} for internal check of all function
arguments; \code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
A list containing the \code{n_new_factors}-dimensional vector of SDF
coefficients in \code{"sdf_coefficients"} and corresponding standard errors in
\code{"standard_errors"}; it also returns the index of control factors that are
selected by the two-step selection procedure.
}
\description{
Computes the three-pass procedure of Feng Giglio and Xiu (2020)
\url{doi:org/10.1111/jofi.12883}, which evaluates the contribution
to cross-sectional pricing of any new factors on top of a set of control
factors.
The third step is a OLS regression of average returns on the covariances between
asset returns and the new factors, as well as the control factors selected
in either one of the first two steps.
The first stwo steps consists in (i) a Lasso regression of average returns
on the ovariances between asset returns and all control factors and (ii)
a Lasso regression of the covariances between asset returns and the new factors
on the ovariances between asset returns and all control factors.
The second selection aims at correcting for potential omitted variables in the
first selection.
Tuning of the penalty parameters in the Lasso regressions is performed via
Cross Validation (CV).
Standard errors are computed following Feng Giglio and Xiu (2020) using the
Newey-West (1994) \url{doi:10.2307/2297912} plug-in procedure to select the number
of relevant lags, i.e., \code{n_lags = 4 * (n_observations/100)^(2/9)}.
For the standard error computations, the function allows to internally
pre-whiten the series by fitting a VAR(1),
i.e., a vector autoregressive model of order 1.
}
\examples{
# import package data on 6 risk factors and 42 test asset excess returns
control_factors = intrinsicFRP::factors[,2:4]
new_factors = intrinsicFRP::factors[,5:7]
returns = intrinsicFRP::returns[,-1]
RF = intrinsicFRP::risk_free[,-1]

gross_returns = returns + 1 + RF

output = FGXFactorsTest(
  gross_returns,
  control_factors,
  new_factors
)

}
