% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taux_v.R
\encoding{UTF-8}
\name{taux_v}
\alias{taux_v}
\title{Calcul de taux de variation entre les observations d'une serie.}
\usage{
taux_v(data, date, x, variation = "dtd", p = -7, normaliz = FALSE, decimal = 2)
}
\arguments{
\item{data}{Un objet de type data.frame contenant au minimum la serie numerique et un vecteur de type date.}

\item{date}{La date de l'observation d’arrivée.}

\item{x}{Un vecteur de type numeric contenant les observations du phénomène à etudier.}

\item{variation}{Un objet de type character, definissant le type de variation à calculer. Sa valeur par defaut est \code{dtd}.}

\item{p}{Une valeur de type entier qui permet de décaler le jour pour une variation journalière. Sa valeur par defaut est \code{-7}.}

\item{normaliz}{Un objet de type logic, permettant de preciser si la variation doit se faire à base egale pour des périodes. Sa valeur par defaut est \code{FALSE}.}

\item{decimal}{Un objet de type numeric permettant de préciser le nombre d'entier à afficher après la virgule. Sa valeur par defaut est \code{2}.}
}
\value{
Un vecteur de longieur 1.
}
\description{
Cette fonction permet de calculer le taux de variation entre les valeurs d'une série à une date ou une periode.
}
\examples{
x <- rnorm(222, mean = 50, sd = 6.3)
date <- seq.Date(as.Date("2023-01-01"), by = "day", len = 222)
df <- data.frame(date, x)
taux_v(df, date = "2023-04-30", x = "x")

}
