% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformalMaps.R
\name{square2disk}
\alias{square2disk}
\title{Square to disk}
\usage{
square2disk(z)
}
\arguments{
\item{z}{a complex number in the unit square \eqn{[0,1] \times [0,1]}}
}
\value{
A complex number in the unit disk.
}
\description{
Conformal map from the unit square to the unit disk. The 
  function is vectorized.
}
\examples{
x <- y <- seq(0, 1, length.out = 25L)
Grid <- transform(
  expand.grid(X = x, Y = y), 
  Z = complex(real = X, imaginary = Y)
)
u <- square2disk(Grid$Z)
plot(u, pch = 19, asp = 1)
}
