% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdist.R
\name{k}
\alias{dk}
\alias{k}
\alias{pk}
\alias{qk}
\alias{rk}
\title{The K-distribution.}
\usage{
dk(x, shape = 1, scale = 1, intensity = FALSE, log = FALSE)

pk(q, shape = 1, scale = 1, intensity = FALSE, log.p = FALSE,
  lower.tail = TRUE)

qk(p, shape = 1, scale = 1, intensity = FALSE, log.p = FALSE)

rk(n, shape = 1, scale = 1, intensity = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape, scale}{shape and scale parameters both defaulting to 1.}

\item{intensity}{logical; if TRUE, quantiles are intensities not amplitudes.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X = x],
otherwise, P[X > x].}

\item{p}{vector of probabilities}

\item{n}{number of observations}
}
\value{
The function \code{dk} gives the density, \code{pk} gives the distribution
        function, \code{qk} gives the quantile function, and \code{rk}
        generates random variates.
}
\description{
Density, distribution function, quantile function and random generation for
the K-distribution with parameters \code{shape} and \code{scale}.
}
\details{
The K-distribution with \code{shape} parameter \eqn{\nu} and 
         \code{scale} parameter \eqn{b} has amplitude density given by
         \eqn{f(x) = [4 x^\nu / \Gamma(\nu)]
                     [(\nu / b)^(1+\nu/2)]
                     K(2 x \sqrt(\nu/b),\nu-1)}.
         Where \eqn{K} is a modified Bessel function of the second kind.
         For \eqn{\nu -> Inf}, the K-distrubution tends to a Rayleigh
         distribution, and for \eqn{\nu = 1} it is the Exponential
         distribution.
         The function \code{base::besselK} is used in the calculation, and
         care should be taken with large input arguements to this function,
         e.g. \eqn{b} very small or \eqn{x, \nu} very large.
         The cumulative distribution function for
         the amplitude, \eqn{x} is given by
         \eqn{F(x) = 1 - 2 x^\nu (\nu/b)^(\nu/2) K(2 x \sqrt(\nu/b), \nu)}.
         The K-Distribution is a compound distribution, with Rayleigh
         distributed amplitudes (exponential intensities) modulated by another
         underlying process whose amplitude is chi-distributed and whose
         intensity is Gamma distributed. An Exponential distributed number
         multiplied by a Gamma distributed random number is used to
         generate the random variates.
         The \eqn{m}th moments are given by \eqn{\mu_m = (b/\nu)^(m/2) \Gamma(0.5m + 1)
         \Gamma(0.5m + \nu) / \Gamma(\nu)}, so that the root mean square
         value of x is the \code{scale} factor, \eqn{<x^2> = b}.
}
\examples{
#=====
r <- rk(10000, shape = 3, scale = 5, intensity = FALSE)
fn <- stats::ecdf(r)
x <- seq(0, 10, length = 100)
plot(x, fn(x))
lines(x, pk(x, shape = 3, scale = 5, intensity = FALSE))
#======
r <- rk(10000, shape = 3, scale = 5, intensity = FALSE)
d <- density(r)
x <- seq(0, 10, length = 100)
plot(d, xlim=c(0,10))
lines(x, dk(x, shape = 3, scale = 5, intensity = FALSE))
}
\references{
E Jakeman and R J A Tough, "Non-Gaussian models for the
            statistics of scattered waves", Adv. Phys., 1988, vol. 37, No. 5,
            pp471-529
}
\seealso{
\href{https://CRAN.R-project.org/view=Distributions}{Distributions}
         for other standard distributions, including \code{dweibull} for the Weibull
         distribution and \code{dexp} for the exponential distribution.
}

