% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-context.R
\name{extract_and_augment_context}
\alias{extract_and_augment_context}
\title{Combine class-specific context with general context for an event}
\usage{
extract_and_augment_context(event, config, ...)
}
\arguments{
\item{event}{the response received from querying the next invocation
endpoint.}

\item{config}{A list of configuration values as created by the
\code{lambda_config} function.}

\item{...}{additional arguments passed to \code{\link{extract_context}}}
}
\value{
list
}
\description{
The \code{\link{extract_context}} function dispatches on the class of an
event to extract context specific to that class. By default, it returns an
empty list. This function takes that class-specific context and combined it
with the context that is applicable for all classes, contained in both
event headers and environment variables.
}
\section{Event context}{

Context is metadata associated with each invocation. If the handler function
accepts a \code{context} argument then it will automatically receive at runtime a
named list consisting of these values along with the arguments in the body
(if any). For example, a function such as \code{my_func(x, context)} will receive
the context argument automatically. The \code{context} argument must be named
(\code{...} will not work).

Refer to \code{vignette("lambda-runtime-in-container", package = "lambdr")}
for details.
}

\keyword{internal}
