test_that("Core table is returned appropriately for each legislature", {
  skip_on_cran()
  expect_identical(class(get_core("aut")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("can")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("cze")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("esp")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("fra")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("deu")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("irl")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("sco")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("gbr")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("usa_house")), "data.frame")
  Sys.sleep(1)
  expect_identical(class(get_core("usa_senate")), "data.frame")
  Sys.sleep(100)

  expect_true(all(dim(get_core("aut")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("can")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("cze")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("esp")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("fra")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("deu")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("irl")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("sco")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("gbr")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("usa_house")) > 0))
  Sys.sleep(1)
  expect_true(all(dim(get_core("usa_senate")) > 0))
  Sys.sleep(100)

  expect_identical(colnames(get_core("aut"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("can"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("cze"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("esp"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("fra"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("deu"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("irl"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("sco"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("gbr"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("usa_house"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(1)
  expect_identical(colnames(get_core("usa_senate"))[1:3], c("country", "pageid", "wikidataid"))
  Sys.sleep(100)

  expect_identical(sample(get_core("aut")$country, 1), "AUT")
  Sys.sleep(1)
  expect_identical(sample(get_core("can")$country, 1), "CAN")
  Sys.sleep(1)
  expect_identical(sample(get_core("cze")$country, 1), "CZE")
  Sys.sleep(1)
  expect_identical(sample(get_core("esp")$country, 1), "ESP")
  Sys.sleep(1)
  expect_identical(sample(get_core("fra")$country, 1), "FRA")
  Sys.sleep(1)
  expect_identical(sample(get_core("deu")$country, 1), "DEU")
  Sys.sleep(1)
  expect_identical(sample(get_core("irl")$country, 1), "IRL")
  Sys.sleep(1)
  expect_identical(sample(get_core("sco")$country, 1), "SCO")
  Sys.sleep(1)
  expect_identical(sample(get_core("gbr")$country, 1), "GBR")
  Sys.sleep(1)
  expect_identical(sample(get_core("usa_house")$country, 1), "USA-H")
  Sys.sleep(1)
  expect_identical(sample(get_core("usa_senate")$country, 1), "USA-S")
  Sys.sleep(100)
})
