% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_social.R
\name{get_social}
\alias{get_social}
\title{Fetch 'Social' table}
\format{
Data frame with columns (varies by legislature):
\itemize{
\item{wikidataid: Wikidata ID identifying a legislator's Wikidata entry (of class \sQuote{character}).}
\item{twitter: Twitter handle (of class \sQuote{character}).}
\item{facebook: Facebook handle (of class \sQuote{character}).}
\item{youtube: Youtube ID (of class \sQuote{character}).}
\item{googlep: Google Plus ID (of class \sQuote{character}).}
\item{instagram: Instagram handle (of class \sQuote{character}).}
\item{linkedin: LinkedIn ID (of class \sQuote{character}).}
\item{website: Personal website URL (of class \sQuote{character}).}
}
}
\source{
Wikidata API, \url{https://www.wikidata.org/wiki/Wikidata:Main_Page}
}
\usage{
get_social(legislature)
}
\arguments{
\item{legislature}{A character string specifying the three-letter country code of the legislature for which data shall be fetched. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}.}
}
\value{
A data frame with columns as specified above.
}
\description{
Fetches social media handles and website URLs of legislators for the specified legislature. Requires a working Internet connection.
}
\examples{
\donttest{# Get entire 'Social' table forthe UK House of Commons
gbr_social <- get_social(legislature = "gbr")
tibble::glimpse(gbr_social)

# Get 'Social' table for members of the UK House of Commons with available TheyWorkForYou ID
gbr_social_subset <- dplyr::semi_join(x = gbr_social,
                                      y = dplyr::filter(get_ids(legislature = "gbr"),
                                                        !is.na(theyworkforyou)),
                                      by = "wikidataid")
tibble::glimpse(gbr_social_subset)
}
}
