% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{DecisionTreeRegressor}
\alias{DecisionTreeRegressor}
\title{DecisionTreeRegressor}
\value{
R6 Class of DecisionTreeRegressor
}
\description{
Wrapper R6 Class of rpart::rpart function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `DecisionTreeRegressor$new`
## ------------------------------------------------

dt <- DecisionTreeRegressor$new()
dt <- DecisionTreeRegressor$new(min_samples_split = 10)
dt <- DecisionTreeRegressor$new(min_samples_leaf = 6, cp = 0.01)

## ------------------------------------------------
## Method `DecisionTreeRegressor$fit`
## ------------------------------------------------

data(abalone)
split_list <- train_test_split(abalone[1:100,], test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

dt <- DecisionTreeRegressor$new()
dt$fit(X_train, y_train)

## ------------------------------------------------
## Method `DecisionTreeRegressor$predict`
## ------------------------------------------------

dt <- DecisionTreeRegressor$new()
dt$fit(X_train, y_train)
preds <- dt$predict(X_test)

dt <- DecisionTreeRegressor$new()
preds <- dt$fit(X_train, y_train)$predict(X_test)

preds <- DecisionTreeRegressor$new()$fit(X_train, y_train)$predict(X_test)
print(head(matrix(c(y_test, preds), ncol = 2, dimnames = (list(NULL, c("True", "Prediction"))))))

## ------------------------------------------------
## Method `DecisionTreeRegressor$get_estimator_type`
## ------------------------------------------------

dt$get_estimator_type()
}
\seealso{
\code{\link[rpart:rpart]{rpart::rpart()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{DecisionTreeRegressor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DecisionTreeRegressor-new}{\code{DecisionTreeRegressor$new()}}
\item \href{#method-DecisionTreeRegressor-fit}{\code{DecisionTreeRegressor$fit()}}
\item \href{#method-DecisionTreeRegressor-predict}{\code{DecisionTreeRegressor$predict()}}
\item \href{#method-DecisionTreeRegressor-get_estimator_type}{\code{DecisionTreeRegressor$get_estimator_type()}}
\item \href{#method-DecisionTreeRegressor-clone}{\code{DecisionTreeRegressor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeRegressor-new"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeRegressor-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of DecisionTreeRegressor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeRegressor$new(
  min_samples_split = 2,
  min_samples_leaf = 1,
  cp = 0.001,
  xval = 10,
  surrogate_style = 0,
  max_depth = 30
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_samples_split}}{The minimum number of observations that must exist in a node in order for a split to be attempted (defaults to 2).}

\item{\code{min_samples_leaf}}{The minimum number of observations in any terminal (leaf) node (defaults to 1).}

\item{\code{cp}}{Complexity Parameter. Any split that does not decrease the overall lack of fit by a factor of cp is not attempted.
This means that the overall R-squared must increase by cp at each step. The main role of this parameter is
to save computing time by pruning off splits that are obviously not worthwhile. (defaults to 0.001)}

\item{\code{xval}}{Number of cross-validations (defaults to 10)}

\item{\code{surrogate_style}}{Controls the selection of a best surrogate. If set to 0 (default) the program uses the total number of correct
classification for a potential surrogate variable, if set to 1 it uses the percent correct, calculated over the non-missing values of the surrogate.
The first option more severely penalizes covariates with a large number of missing values.}

\item{\code{max_depth}}{The maximum depth of any node of the final tree, with the root node counted as depth 0.
Values greater than 30 will give nonsense results on 32-bit machines.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dt <- DecisionTreeRegressor$new()
dt <- DecisionTreeRegressor$new(min_samples_split = 10)
dt <- DecisionTreeRegressor$new(min_samples_leaf = 6, cp = 0.01)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeRegressor-fit"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeRegressor-fit}{}}}
\subsection{Method \code{fit()}}{
Builds a decision tree regressor from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeRegressor$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes response variables}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of DecisionTreeRegressor
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
split_list <- train_test_split(abalone[1:100,], test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

dt <- DecisionTreeRegressor$new()
dt$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeRegressor-predict"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeRegressor-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeRegressor$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The predict values.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dt <- DecisionTreeRegressor$new()
dt$fit(X_train, y_train)
preds <- dt$predict(X_test)

dt <- DecisionTreeRegressor$new()
preds <- dt$fit(X_train, y_train)$predict(X_test)

preds <- DecisionTreeRegressor$new()$fit(X_train, y_train)$predict(X_test)
print(head(matrix(c(y_test, preds), ncol = 2, dimnames = (list(NULL, c("True", "Prediction"))))))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeRegressor-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeRegressor-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeRegressor$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dt$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeRegressor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeRegressor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeRegressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
