% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinal_consensus_cluster.R
\name{test_clustering_methods}
\alias{test_clustering_methods}
\title{Try out different linkage methods}
\usage{
test_clustering_methods(
  results,
  use_methods = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid")
)
}
\arguments{
\item{results}{clustering result of class \code{lcc}}

\item{use_methods}{character vector of one or several items of \code{average},
\code{ward.D}, \code{ward.D2}, \code{single}, \code{complete}, \code{mcquitty},
\code{median} or \code{centroid}}
}
\value{
a list of elements, each element of class \code{lcc}. The entries are
named after the used linkage method.
}
\description{
In the final step, the consensus clustering performs a hierarchical clustering
step on the consensus cluster. This function tries out different linkage
methods and returns the corresponding clusterings. The outputs can be plotted
like the results from \code{\link{longitudinal_consensus_cluster}}.
}
\examples{
set.seed(5)
test_data <- data.frame(patient_id = rep(1:10, each = 4),
visit = rep(1:4, 10),
var_1 = c(rnorm(20, -1), rnorm(20, 3)) +
rep(seq(from = 0, to = 1.5, length.out = 4), 10),
var_2 = c(rnorm(20, 0.5, 1.5), rnorm(20, -2, 0.3)) +
rep(seq(from = 1.5, to = 0, length.out = 4), 10))
model_list <- list(flexmix::FLXMRmgcv(as.formula("var_1 ~ .")),
flexmix::FLXMRmgcv(as.formula("var_2 ~ .")))
clustering <- longitudinal_consensus_cluster(
data = test_data,
id_column = "patient_id",
max_k = 2,
reps = 3,
model_list = model_list,
flexmix_formula = as.formula("~s(visit, k = 4) | patient_id"))

clustering_linkage <- test_clustering_methods(results = clustering,
use_methods = c("average", "single"))
# not run
# plot(clustering_linkage[["single"]])
# end not run
}
