% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_linkage_orthologs.R
\name{subset_linkage_orthologs}
\alias{subset_linkage_orthologs}
\title{Subset Orthologs contained in conserved linkage groups}
\usage{
subset_linkage_orthologs(orthologs_df, linkages = NULL)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded with load_orthologs()}

\item{linkages}{dataframe. table listing the linkage groups as returned by the function compute_linkage_groups()}
}
\value{
A dataframe object
}
\description{
This is a function to subset an orthologs_df and keep only the orthologs that are within significant
linkage groups computed by the function compute_linkage_groups().
}
\examples{
# basic usage of compute_linkage_groups: 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)
                               
my_macrosynteny <- compute_linkage_groups(my_orthologs)

}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}

\code{\link[=compute_linkage_groups]{compute_linkage_groups()}}
}
