% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxcombofunctions-exampledocumentation.R,
%   R/maxcombofunctions.R
\name{oogetdoublemaxcombocutoffgroupsequential}
\alias{oogetdoublemaxcombocutoffgroupsequential}
\title{Compute a cutoff value for a max-combo test statistic in a group sequential setting}
\usage{
oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint,
  oolistlistweightingfunctionsbytimepoint,
  oovecdoublecutoffsUsedInEachPreviousTimepoint,
  oodoublealphaincrement,
  oostringorsymbolid = "id",
  oostringorsymboltreated = "treated",
  oostringorsymbolAtime = "Atime",
  oostringorsymbolBtime = "Btime",
  oostringorsymbolBobserved = "Bobserved",
  oostringorsymbolCtime = "Ctime",
  oostringorsymbolCobserved = "Cobserved",
  oointnmaxiter = 25L,
  oodoublelower = -10,
  oodoubleupper = 10,
  oodoublefscaletolerance = 1e-05,
  oointnrep = 100000L
)
}
\arguments{
\item{oolistdataframesbytimepoint}{A list of one or more data frames containing time-to-event data from two different arms.  This list should have one data frame for each analysis timepoint, in order from the earliest analysis timepoint up to the current analysis timepoint.  Each such supplied data frame for an analysis timepoint previous to the current analysis timepoint should contain the actual data that was used at that previous analysis timepoint.}

\item{oolistlistweightingfunctionsbytimepoint}{A list with one element for each analysis timepoint, in order from the earliest analysis timepoint up to the current analysis timepoint.  Each element should be itself a list of one or more weighting functions.  Each such element for an analysis timepoint previous to the current analysis timepoint should contain the actual weighting functions that were used at that previous analysis timepoint.  Each weighting function should take as input the pooled Kaplan-Meier estimate of survival across the two arms (i.e., a double between 0 and 1, inclusive) and output a single weight (i.e., a double, typically greater than or equal to zero).}

\item{oovecdoublecutoffsUsedInEachPreviousTimepoint}{A vector of doubles with one element for each \emph{previous} analysis timepoint.  Each such element should contain the actual cutoff value (e.g., as was returned by a previous invocation of this function) that was used at that previous analysis timepoint.  Please note that the length of this argument should be exactly 1 less than the length of \code{oolistdataframesbytimepoint} and \code{oolistlistweightingfunctionsbytimepoint}, which should have exactly the same length.  If there were no previous analysis timepoints (e.g., the current analysis timepoint is the first planned interim analysis timepoint), then this argument should be specified to be \code{base::vector(mode="double",length=0L)}.}

\item{oodoublealphaincrement}{A double that is the user-specified nominal type I error rate for the \emph{current} analysis timepoint.  In a group sequential experiment, the nominal type I error of the experiment is the \emph{sum} of the nominal type I error rates for each respective analysis timepoint.  This value should be strictly greater than 0, and the sum of this value for the current analysis timepoint and any previous analysis timepoints should be strictly less than 1.}

\item{oostringorsymbolid}{The name of the column in the supplied data frames for the id variable.  Defaults to "id".  The id variable should take a unique value for each subject.  The column with this name in the data frames can be an integer vector with a different integer for each subject; the function will most likely also work if the column is a character vector with a different value for each subject.}

\item{oostringorsymboltreated}{The name of the column in the supplied data frames for a treatment indicator variable.  Defaults to "treated".  The treatment indicator variable is a variable indicating which of the two arms the subject is in.  The column with this name in the data frames should be an integer vector that takes only the value 0L (e.g., for placebo) or the value 1L (e.g., for a new drug or therapy).  The test statistic that is returned by this function will generally be for a test that the arm represented by subjects with treatment indicator 1L is superior to the arm represented by subjects with treatment indicator 0L (i.e., a one-sided test of superiority of arm 1 over arm 0).}

\item{oostringorsymbolAtime}{The name of the column in the supplied data frames for the Atime variable.  Defaults to "Atime".  Atime is the absolute time the subject enters the study.  The column with this name in the data frames can be vector of doubles; the function will most likely also work if the column is a vector of integers.}

\item{oostringorsymbolBtime}{The name of the column in the supplied data frames for the Btime variable.  Defaults to "Btime".  Btime is the absolute time of an event or censoring, whichever comes first.  The column with this name in the data frames can be vector of doubles; the function will most likely also work if the column is a vector of integers.}

\item{oostringorsymbolBobserved}{The name of the column in the supplied data frames for the Bobserved variable.  Defaults to "Bobserved".  Bobserved should be TRUE if the event was observed.  The column with this name in the data frames can be a logical vector; the function will most likely also work if the column is a vector of integers (i.e., with 1L in place of TRUE and 0L in place of FALSE).}

\item{oostringorsymbolCtime}{The name of the column in the supplied data frames for the Ctime variable.  Defaults to "Ctime".  Ctime is the absolute time of an event or censoring, whichever comes first.  The column with this name in the data frames can be vector of doubles; the function will most likely also work if the column is a vector of integers.}

\item{oostringorsymbolCobserved}{The name of the column in the supplied data frames for the Cobserved variable.  Defaults to "Cobserved".  Cobserved should be TRUE if censoring occurred (and so the event was not observed).  The column with this name in the data frame can be a logical vector; the function will most likely also work if the column is a vector of integers (i.e., with 1L in place of TRUE and 0L in place of FALSE).}

\item{oointnmaxiter}{An integer that is maximum number of iterations used by the bisection method while finding the cutoff.  Defaults to 25L.  This value can be increased to 50L, 100L, or 200L if greater accuracy is desired while finding the cutoff; anything greater than that would typically not be needed.}

\item{oodoublelower}{A double that is the lower bound of the interval within which the cutoff is searched for.  Defaults to -10.}

\item{oodoubleupper}{A double that is the upper bound of the interval within which the cutoff is searched for.  Defaults to 10.}

\item{oodoublefscaletolerance}{A double that is related to early stopping of the bisection method; if the bisection method finds a cutoff value for which the absolute value of the difference between the nominal type I error rate when using that cutoff value and the user-specified nominal type I error rate is less than or equal to \code{oodoublefscaletolerance}, the bisection method will stop and return that cutoff value.  Defaults to 0.00001.  This value can be decreased to a smaller strictly positive value if greater accuracy is desired while finding the cutoff.}

\item{oointnrep}{This function may use repeated simulations to estimate the type I error rate; this argument controls how many simulations are used to do this.  Defaults to 100000L.  There is typically not much need to change this argument from its default value.}
}
\value{
A double
}
\description{
This function computes a cutoff value for a max-combo test statistic that is used in a group sequential setting.  For example, consider the situation of a clinical trial with a planned interim analysis 2 years after the start of the clinical trial and a planned final analysis 4 years after the start of the clinical trial that plans to control the type I error rate across the interim and final analyses at the 0.025 level.  Suppose the interim analysis took place 2 years after a clinical trial began, and at the time of that interim analysis, equality of the true survival curves for the two arms was tested using a max-combo test statistic based on the log-rank test statistic and the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function using a nominal type I error rate of 0.06 x 0.025 = 0.0015, which is what might be done in a study using the typical and conservative O'Brien-Fleming-like type I error spending, and further suppose that that max-combo test failed to reject equality of the survival curves for the two arms.  Suppose that now 4 years have elapsed since the start of the study, so the final analysis is now taking place. Suppose that, as per the study protocol, the final analysis uses a max-combo test statistic based on the log-rank test statistic, the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function, \emph{and} the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function.  This is a scenario in which this function might be used, e.g., to compute a cutoff value for the max-combo test statistic for the final analysis; if the max-combo test statistic for the final analysis exceeds the cutoff returned by this function, then the study can declare that the survival curves in the two arms are statistically significantly different according to its planned analysis (note that in this case, the \code{oodoublealphaincrement} argument should be specified to be 0.94 x 0.025 = 0.0235).

Please note that this function allows for the possibility that zero, one, two, or more interim analyses have occurred.  Please also note that the arguments to this function expect only data and information related to the current analysis and previous analyses; this function does not expect any information in its arguments related to future planned analyses or planned future type I error spending.  Also please note that, in a real clinical study, the timing of the analyses would most likely be based on the number of events that have occurred, possibly in addition to considerations related to elapsed time since the beginning of the study (e.g., "the interim analysis will take place after 50 events have occurred, and the final analysis will take place after 100 events have occurred or 4 years have elapsed since the start of the study, whichever occurs first"); this function is compatible with such scenarios.  If the true survival curves from the two arms are not at all different, then the probability, before performing the experiment, that at least one of the multiple max-combo statistics at the respective multiple analysis timepoints will be greater than its respective cutoff value for that timepoint returned by this function, is less than or approximately equal to (but typically approximately equal to) the nominal type I error rate for the group sequential experiment (e.g., 0.025 for a confirmatory clinical trial).

A max-combo test statistic is the maximum of multiple standardized weighted log-rank test statistics.  The user of the function is expected to provide the function with a \emph{list} of data frames containing the time-to-event data for the two arms; this list should contain one data frame for each previous analysis that has occurred and one data frame for the current analysis, in order, from earliest analysis timepoint up to the current analysis timepoint.  Each such data frame is expected to be in a particular format (see more details below).  Additionally, the user of the function is expected to provide a \emph{list} of lists of one or more weighting functions to use for the respective one or more weighted log-rank tests for each analysis timepoint; in particular this function only allows the user to specify a weighting function that takes as input the Kaplan-Meier estimate for the survival curve obtained by pooling both of the two arms (a double that is between 0 and 1, inclusive) and provides as output a weight (a double that is typically greater than or equal to zero); note that the Fleming-Harrington class of weighting functions falls within what can be specified in this way.  For each list of weighting functions for a previous analysis timepoint, the list should contain the actual weighting functions that were used at that analysis timepoint.  The list of weighting functions for the current analysis timepoint should contain the weighting functions that were planned to be used at the current analysis timepoint.

Each supplied data frame is expected to have one row for each subject.  Each data frame should have the following columns:
\itemize{
\item \code{id} - a variable that takes a unique value for each subject
\item \code{treated} - should be 0 for subjects in the control arm and 1 for subjects in the experimental arm.
\item \code{Atime} - the absolute time the subject enters the study
\item \code{Btime} - the absolute time of an event or censoring, whichever comes first
\item \code{Bobserved} - should be TRUE if the event was observed
\item \code{Ctime} - the absolute time of an event or censoring, whichever comes first
\item \code{Cobserved} - should be TRUE if censoring occurred (and so the event was not observed)
}

The columns in the data frame do not have to be named exactly as above; however, if different names are used, those names must be specified as arguments to the function, and those names should be the same for each supplied data frame in the list of data frames supplied to the function.  Please see below for more detail regarding how to specify those names and for more detail regarding the expectations of the function regarding the columns in the data frames.
}
\examples{
\donttest{

#this function is used in the examples below to create synthetic earlier looks
#at the simulated datasets.
oogetdataframeearlierlookattime=function(oodataframe,oodoubletime)
{
  dplyr::mutate(
    dplyr::filter(oodataframe,Atime <= oodoubletime),
    Bobserved = base::ifelse(Btime <= oodoubletime,Bobserved,FALSE),
    Cobserved = base::ifelse(Ctime <= oodoubletime,Cobserved,FALSE),
    Btime = base::pmin(Btime,oodoubletime),
    Ctime = base::pmin(Ctime,oodoubletime)
  )
}

# -------------------------------------------------------------------------------
# Example 1: Usage on a single deterministic dataset in which the drug halves
# the hazard at all times (i.e., a proportional hazards situation)
# -------------------------------------------------------------------------------

oointnparticipants=100L
oointnparticipantsplacebo=oointnparticipants/2L
oointnparticipantsactive=oointnparticipants/2L

oodoublerateplacebo=0.250
oodoublerateactive=0.125

oovecinttreated=c(
  base::rep(0L,length.out=oointnparticipantsplacebo),
  base::rep(1L,length.out=oointnparticipantsactive)
)
oovecdoubletAabsolute=c( #the start time, i.e., when the subject enters the study.
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsplacebo),
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsactive)
)
#the duration of time from when the subject enters the study until the subject experiences the event
oovecdoubletAtoB=c(
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
    rate=oodoublerateplacebo
  ),
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsactive),
    rate=oodoublerateactive
  )
)
oovecdoubletBabsolute=oovecdoubletAabsolute + oovecdoubletAtoB
#the final analysis takes place at absolute time 6.0 months, and no other
#censoring (e.g., dropout) occurs
oovecdoubletCabsolute=6.0
oovecdoubletminBvsC=base::pmin(oovecdoubletBabsolute,oovecdoubletCabsolute)
oovecboolobservedB=(oovecdoubletBabsolute < oovecdoubletCabsolute)
oovecboolobservedC=(oovecdoubletCabsolute <= oovecdoubletBabsolute)

oodataframe=dplyr::tibble(id=1L:oointnparticipants,
                          treated=oovecinttreated,
                          Atime=oovecdoubletAabsolute,
                          Btime=oovecdoubletminBvsC,
                          Bobserved=oovecboolobservedB,
                          Ctime=oovecdoubletminBvsC,
                          Cobserved=oovecboolobservedC)

oodataframeinterimanalysis=oogetdataframeearlierlookattime(
  oodataframe = oodataframe,
  oodoubletime = 3.0 #the interim analysis takes place at absolute time 3.0 months
)
oodataframefinalanalysis=oodataframe #the final analysis takes place at absolute time 6.0 months



#plan to use the standardized log-rank test statistic at both the interim and the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.36 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.36 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.92 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 1.96 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.92 > 1.96),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level



#plan to use the standardized log-rank test statistic at the interim analysis and to use the
#max-combo test statistic based on the standardized log-rank test statistic and the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater
#weight on later times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.36 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.36 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.92 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.12 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.92 > 2.12),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level



#plan to use the standardized log-rank test statistic at the interim analysis and to use the
#max-combo test statistic based on the standardized log-rank test statistic, the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater
#weight on later times, and the weighted log-rank test statistic with Fleming-Harrington 1-0
#weighting function, which places greater weight on earlier times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.36 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.36 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.92 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.19 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.92 > 2.19),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level



#plan to use the standardized log-rank test statistic and the weighted log-rank test
#statistic with Fleming-Harrington 0-1 weighting function at the interim analysis and to use
#the max-combo test statistic based on the standardized log-rank test statistic, the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater weight
#on later times, and the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting
#function, which places greater weight on earlier times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.56 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 3.13 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.56 < 3.13)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.92 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.20 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.92 > 2.20),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level


# --------------------------------------------------------------------------------------------
# Example 2: Usage on a single deterministic dataset in which the drug delays
# the event by exactly one month for each subject (i.e., an early treatment effect situation)
# --------------------------------------------------------------------------------------------

oointnparticipants=100L
oointnparticipantsplacebo=oointnparticipants/2L
oointnparticipantsactive=oointnparticipants/2L

oodoublerateplacebo=0.250

oovecinttreated=c(
  base::rep(0L,length.out=oointnparticipantsplacebo),
  base::rep(1L,length.out=oointnparticipantsactive)
)
oovecdoubletAabsolute=c( #the start time, i.e., when the subject enters the study.
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsplacebo),
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsactive)
)
#the duration of time from when the subject enters the study until the subject experiences the event
oovecdoubletAtoB=c(
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
    rate=oodoublerateplacebo
  ),
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsactive),
    rate=oodoublerateplacebo
  ) + 1.0 #note the addition of 1.0 month time to event here for the active arm
)
oovecdoubletBabsolute=oovecdoubletAabsolute + oovecdoubletAtoB
#the analysis takes place at absolute time 6.0 months, and no other censoring (e.g., dropout) occurs
oovecdoubletCabsolute=6.0
oovecdoubletminBvsC=base::pmin(oovecdoubletBabsolute,oovecdoubletCabsolute)
oovecboolobservedB=(oovecdoubletBabsolute < oovecdoubletCabsolute)
oovecboolobservedC=(oovecdoubletCabsolute <= oovecdoubletBabsolute)

oodataframe=dplyr::tibble(id=1L:oointnparticipants,
                          treated=oovecinttreated,
                          Atime=oovecdoubletAabsolute,
                          Btime=oovecdoubletminBvsC,
                          Bobserved=oovecboolobservedB,
                          Ctime=oovecdoubletminBvsC,
                          Cobserved=oovecboolobservedC)

oodataframeinterimanalysis=oogetdataframeearlierlookattime(
  oodataframe = oodataframe,
  oodoubletime = 3.0 #the interim analysis takes place at absolute time 3.0 months
)
oodataframefinalanalysis=oodataframe #the final analysis takes place at absolute time 6.0 months



#plan to use the standardized log-rank test statistic at both the interim and the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.51 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.51 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 1.66 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 1.96 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis does not exceed the cutoff
#(since 1.66 < 1.96), so you fail to reject that the survival curves in the two arms are
#the same at the 0.025 level



#plan to use the standardized log-rank test statistic at the interim analysis and to use the
#max-combo test statistic based on the standardized log-rank test statistic and the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater
#weight on later times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.51 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.51 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 1.66 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.12 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis does not exceed the cutoff
#(since 1.66 < 2.12), so you fail to reject that the survival curves in the two arms are
#the same at the 0.025 level



#plan to use the standardized log-rank test statistic at the interim analysis and to use the
#max-combo test statistic based on the standardized log-rank test statistic, the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater
#weight on later times, and the weighted log-rank test statistic with Fleming-Harrington 1-0
#weighting function, which places greater weight on earlier times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.51 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.51 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.07 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.19 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis does not exceed the cutoff
#(since 2.07 < 2.19), so you fail to reject that the survival curves in the two arms are
#the same at the 0.025 level



#plan to use the standardized log-rank test statistic and the weighted log-rank test
#statistic with Fleming-Harrington 0-1 weighting function, which places greater weight on
#later times, at the interim analysis and to use the max-combo test statistic based on
#the standardized log-rank test statistic, the weighted log-rank test statistic with
#Fleming-Harrington 0-1 weighting function, which places greater weight on later times,
#and the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting
#function, which places greater weight on earlier times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.51 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 3.13 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.51 < 3.13)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.07 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.20 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis does not exceed the cutoff
#(since 2.07 < 2.20), so you fail to reject that the survival curves in the two arms are
#the same at the 0.025 level


#plan to use the standardized log-rank test statistic and the weighted log-rank test
#statistic with Fleming-Harrington 1-0 weighting function, which places greater weight on
#earlier times, at the interim analysis and to use the max-combo test statistic based on
#the standardized log-rank test statistic, the weighted log-rank test statistic with
#Fleming-Harrington 1-0 weighting function, which places greater weight on earlier times,
#at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 2.71 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 3.02 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 2.71 < 3.02)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.07 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.06 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.07 > 2.06),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level


# -------------------------------------------------------------------------------------------------
# Example 3: Usage on a single deterministic dataset in which subjects in the placebo arm all have
# the event after being on the study for 1.2 months (i.e., a delayed treatment effect situation)
# -------------------------------------------------------------------------------------------------
 
oointnparticipants=100L
oointnparticipantsplacebo=oointnparticipants/2L
oointnparticipantsactive=oointnparticipants/2L

oodoublerateactive=0.250

oovecinttreated=c(
  base::rep(0L,length.out=oointnparticipantsplacebo),
  base::rep(1L,length.out=oointnparticipantsactive)
)
oovecdoubletAabsolute=c( #the start time, i.e., when the subject enters the study.
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsplacebo),
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsactive)
)
#the duration of time from when the subject enters the study until the subject experiences the event
oovecdoubletAtoB=c(
  base::ifelse(
    stats::qexp(
      base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
      rate=oodoublerateactive
    ) <= 1.2,
    stats::qexp(
      base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
      rate=oodoublerateactive
    ),
    1.2
  ),
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsactive),
    rate=oodoublerateactive
  )
)
oovecdoubletBabsolute=oovecdoubletAabsolute + oovecdoubletAtoB
#the analysis takes place at absolute time 6.0 months, and no other censoring (e.g., dropout) occurs
oovecdoubletCabsolute=6.0
oovecdoubletminBvsC=base::pmin(oovecdoubletBabsolute,oovecdoubletCabsolute)
oovecboolobservedB=(oovecdoubletBabsolute < oovecdoubletCabsolute)
oovecboolobservedC=(oovecdoubletCabsolute <= oovecdoubletBabsolute)

oodataframe=dplyr::tibble(id=1L:oointnparticipants,
                          treated=oovecinttreated,
                          Atime=oovecdoubletAabsolute,
                          Btime=oovecdoubletminBvsC,
                          Bobserved=oovecboolobservedB,
                          Ctime=oovecdoubletminBvsC,
                          Cobserved=oovecboolobservedC)

oodataframeinterimanalysis=oogetdataframeearlierlookattime(
  oodataframe = oodataframe,
  oodoubletime = 3.0 #the interim analysis takes place at absolute time 3.0 months
)
oodataframefinalanalysis=oodataframe #the final analysis takes place at absolute time 6.0 months



#plan to use the standardized log-rank test statistic at both the interim and the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 1.24 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 1.24 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 1.55 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 1.96 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis does not exceed the cutoff
#(since 1.55 < 1.96), so you fail to reject that the survival curves in the two arms are
#the same at the 0.025 level



#plan to use the standardized log-rank test statistic at the interim analysis and to use the
#max-combo test statistic based on the standardized log-rank test statistic and the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater
#weight on later times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 1.24 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 1.24 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.28 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.12 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.28 > 2.12),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level



#plan to use the standardized log-rank test statistic at the interim analysis and to use the
#max-combo test statistic based on the standardized log-rank test statistic, the weighted
#log-rank test statistic with Fleming-Harrington 0-1 weighting function, which places greater
#weight on later times, and the weighted log-rank test statistic with Fleming-Harrington 1-0
#weighting function, which places greater weight on earlier times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 1.24 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 2.97 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 1.24 < 2.97)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.28 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.16 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.28 > 2.16),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level



#plan to use the standardized log-rank test statistic and the weighted log-rank test
#statistic with Fleming-Harrington 0-1 weighting function, which places greater weight on
#later times, at the interim analysis and to use the max-combo test statistic based on
#the standardized log-rank test statistic, the weighted log-rank test statistic with
#Fleming-Harrington 0-1 weighting function, which places greater weight on later times,
#and the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting
#function, which places greater weight on earlier times, at the final analysis
oolistlistweightingfunctionsbytimepoint=base::list(
  interim=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
  ),
  final=base::list(
    logrank=function(stminus){ base::return(1.0) },
    flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
    flemingharrington10=function(stminus){ base::return(stminus) }
  )
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframeinterimanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[1L]]
) #max-combo test statistic 1.88 at the interim analysis
oodoublecutoffforinterimanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:1L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = base::vector(mode="double",length=0L),
  oodoublealphaincrement = 0.06*0.025
)
oodoublecutoffforinterimanalysis #cutoff of 3.12 for the max-combo test statistic at
#the interim analysis
#the max-combo test statistic at the interim analysis does not exceed the cutoff (since 1.88 < 3.12)
#so the experiment continues until the final analysis.

maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframefinalanalysis,
  oolistfunctionweightasafunctionofstminus = oolistlistweightingfunctionsbytimepoint[[2L]]
) #max-combo test statistic 2.28 at the final analysis
oodoublecutoffforfinalanalysis=maxcombo::oogetdoublemaxcombocutoffgroupsequential(
  oolistdataframesbytimepoint = base::list(oodataframeinterimanalysis,oodataframefinalanalysis),
  oolistlistweightingfunctionsbytimepoint = oolistlistweightingfunctionsbytimepoint[1L:2L],
  oovecdoublecutoffsUsedInEachPreviousTimepoint = c(oodoublecutoffforinterimanalysis),
  oodoublealphaincrement = 0.025 - 0.06*0.025
)
oodoublecutoffforfinalanalysis #cutoff of 2.16 for the max-combo test statistic at
#the final analysis
#the max-combo test statistic at the final analysis exceeds the cutoff (since 2.28 > 2.16),
#so you can declare that the survival curves in the two arms are statistically significantly
#different at the 0.025 level
}
}
