% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-detect_iodine_deficiency.R
\name{detect_iodine}
\alias{detect_iodine}
\alias{detect_iodine_general}
\alias{detect_iodine_pregnant}
\alias{detect_iodine_lactating}
\title{Determine population level iodine intake status}
\usage{
detect_iodine(
  iodine = NULL,
  group = c("general", "pregnant", "lactating"),
  label = TRUE
)

detect_iodine_general(iodine = NULL, label = TRUE)

detect_iodine_pregnant(iodine = NULL, label = TRUE)

detect_iodine_lactating(iodine = NULL, label = TRUE)
}
\arguments{
\item{iodine}{A numeric value or numeric vector of median urinary iodine
concentration (microgram/L) of the population or populations of interest.}

\item{group}{The population group of interest. Either school age children
(\strong{general}), pregnant women (\strong{pregnant}), or lactating women with
children under 2 years old (\strong{lactating})}

\item{label}{Logical. Should labels be used to classify iodine intake
status? If TRUE (default), status is classified descriptively as
insufficient, adequate, excessive, or the like. If FALSE, simple integer
codes are returned.}
}
\value{
If \code{label} is TRUE, a character value or character vector of iodine
intake status. If \code{label} is FALSE, an integer value or integer vector of
iodine intake status.
}
\description{
Determining population level iodine intake status using mean urinary iodine
concentration for school age children (\strong{general}), pregnant women
(\strong{pregnant}), or lactating women with children under 2 years old
(\strong{lactating}).
}
\examples{
detect_iodine(iodine = 10)

}
\author{
Nicholus Tint Zaw and Ernest Guevarra
}
