% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noah.R
\name{pseudonymize}
\alias{pseudonymize}
\title{Create unique pseudonyms}
\usage{
pseudonymize(..., .alliterate = NULL, .ark = NULL)
}
\arguments{
\item{...}{One or multiple objects to use as keys for which pseudonyms
should be created, usually one or more columns of a data frame.
All objects must be of the same length.}

\item{.alliterate}{Logical. Should only pseudonyms that are alliterations be
returned? Defaults to FALSE, or TRUE if set as TRUE for the Ark provided to
\code{.ark}. If set, takes precedence over the Ark's default setting.}

\item{.ark}{An Ark object. If NULL (default) a new Ark is created. Using an
existing Ark makes sure that the same input returns the same pseudonym.}
}
\value{
A character vector of pseudonyms.
}
\description{
Pseudonymize returns unique pseudonyms for R objects.
It accepts any number of vectors and data frame as arguments and will use
them as keys for the pseudonym creation.
Vectors and data frames must have identical length.
Elements in the same position or row are treated as part of the same key.
The same key is always assigned the same pseudonym. Different keys are
always assigned different pseudonyms.
}
\examples{
pseudonymize("Mata Hari")
}
