% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/028_pmd_con_ln.R
\name{pmd_con_ln}
\alias{pmd_con_ln}
\alias{pmd_con_ln.default}
\alias{pmd_con_ln.formula}
\title{PMD-based confidence label noise}
\usage{
\method{pmd_con_ln}{default}(x, y, level, sortid = TRUE, ...)

\method{pmd_con_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{PMD-based confidence label noise} into a classification dataset.
}
\details{
\emph{PMD-based confidence label noise} approximates the probability of noise using 
the confidence prediction of a neural network. These predictions are used to estimate the 
mislabeling probability and the most possible noisy class label for each sample. Finally,
(\code{level}·100)\% of the samples in the dataset are randomly selected to be mislabeled
according to their values of probability computed.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- pmd_con_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- pmd_con_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
Y. Zhang, S. Zheng, P. Wu, M. Goswami, and C. Chen. 
\strong{Learning with feature-dependent label noise: A progressive approach}. 
In \emph{Proc. 9th International Conference on Learning Representations}, pages 1-13, 2021.
url:\url{https://openreview.net/forum?id=ZPa2SyGcbwh}.
}
\seealso{
\code{\link{clu_vot_ln}}, \code{\link{sco_con_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
