% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{get_history_candles}
\alias{get_history_candles}
\title{Retrieve the candlestick charts}
\usage{
get_history_candles(
  api_key,
  secret_key,
  passphrase,
  bar = c("1m", "3m", "5m", "15m", "30m", "1H", "4H", "6H", "12H", "1D", "2D", "3D"),
  count,
  instId,
  ...
)
}
\arguments{
\item{api_key}{Okx API key.}

\item{secret_key}{Okx API secret key.}

\item{passphrase}{Okx API passphrase.}

\item{bar}{Bar size, the default is 1m, e.g. 1m/3m/5m/15m/30m/1H/2H/4H, Hong Kong time opening price k-line: 6H/12H/1D/2D/3D.}

\item{count}{Number of Bars.}

\item{instId}{Instrument ID, e.g. BTC-USDT-SWAP.}

\item{...}{Other request parameters to be passed, See \href{https://www.okx.com/docs-v5/en/#rest-api-market-data-get-candlesticks-history}{Get candlesticks history} for more information.}
}
\value{
Candlestick charts data
}
\description{
Wrapper for API \href{https://www.okx.com/docs-v5/en/#rest-api-market-data-get-candlesticks}{Get candlesticks}
and \href{https://www.okx.com/docs-v5/en/#rest-api-market-data-get-candlesticks-history}{Get candlesticks history}.
}
\examples{
\dontrun{
candles <- get_history_candles(
  api_key, secret_key, passphrase, bar = "1m",
  count = 24*60, instId = "CFX-USDT-SWAP"
)
}

}
