% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordgam.R
\name{ordgam}
\alias{ordgam}
\title{Fit of an additive proportional odds model for ordinal data using Laplace approximations and P-splines}
\usage{
ordgam(
  formula,
  data,
  nc = NULL,
  K = 10,
  pen.order = 2,
  descending = TRUE,
  select.lambda = TRUE,
  lambda.family = "dgamma",
  lambda.optimizer = "nlminb",
  lprior.lambda = function(x) dgamma(x, 1, 1e-04, log = TRUE),
  theta0 = NULL,
  lambda0 = NULL,
  ci.level = 0.95,
  verbose = FALSE
)
}
\arguments{
\item{formula}{A model formula}

\item{data}{A data frame containing a column 'y' with the ordinal response (taking integer values) besides the covariates.}

\item{nc}{(optional) Number of categories for the ordinal response.}

\item{K}{Number of B-splines to model each additive term (Default: 10).}

\item{pen.order}{Penalty order (Default: 2).}

\item{descending}{Logical indicating if the odds of the response taking a value in the upper scale should be preferred over values in the lower scale (Default: TRUE).}

\item{select.lambda}{Logical indicating if the penalty parameters should be tuned (Default: TRUE).}

\item{lambda.family}{Prior for <lambda>. Possible choices are "none", "dgamma", "BetaPrime" or "myprior" for a user specified function for the prior of <lambda>.}

\item{lambda.optimizer}{Algorithm used to maximize p(lambda|data). Possible choices are "nlminb","ucminf","nlm","LevMarq" (Default: "nlminb").}

\item{lprior.lambda}{Log of the prior density for a <lambda> component if \code{lambda.family} set to "myprior".}

\item{theta0}{(Optional) Vector containing starting values for the regression parameters.}

\item{lambda0}{Vector of penalty parameters for the additive terms (Default: 10 for each additive term).}

\item{ci.level}{Confidence levels of the computed credible intervals for the regression parameters.}

\item{verbose}{Verbose mode (logical)}
}
\value{
an object of type \code{\link{ordgam.object}}.
}
\description{
Fit of an additive proportional odds model for ordinal data using Laplace approximations and P-splines
}
\examples{
library(ordgam)
data(freehmsData)
mod = ordgam(freehms ~ gndr + s(eduyrs) + s(age),
             data=freehmsData, descending=TRUE)
print(mod)
plot(mod)

}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
\seealso{
\code{\link{ordregr}}, \code{\link{ordgam.object}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
