% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{Generate a Personality Test Report}
\usage{
report(responses, path)
}
\arguments{
\item{responses}{A numeric vector to represent
your answers to the questions in the test.}

\item{path}{A string to set where to store your test report.}
}
\value{
No return value, two files
named "report.Rmd" and "report.html" generates in your path.
}
\description{
Generate a personality test report without launching the test.
}
\details{
\code{report} will be automatically called after
you call \code{launch_test} and submit your responses.

The report summaries your test results, and compares them to other people's
to tell you what the results mean.
}
\examples{

if (interactive()) {
  # a numeric vector representing your responses to the test
  rs <- rep(1, 50)

  # generate report
  path <- tempdir()
  report(rs, path)
}

}
\seealso{
\code{\link{launch_test}} to launch the personality test.
}
