% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nested_Stats_Sbar.R
\name{Nested_Stats_Sbar}
\alias{Nested_Stats_Sbar}
\title{Predictive Accuracy Testing for Nested Environment SBar}
\usage{
Nested_Stats_Sbar(Ehat1, Ehat2, lam20, tau0)
}
\arguments{
\item{Ehat1}{Residual series from Model 1 (the smaller model). One dimension and numeric.}

\item{Ehat2}{Residual series from Model 2 (the larger/nested model). One dimension and numeric.}

\item{lam20}{Fraction of the sample used for Model 2, which should be within 0 and 1.}

\item{tau0}{Fraction to determine the user-chosen range of lam10 over which the average is taken.}
}
\value{
A list of SBar statistics and corresponding P values will be produced. "adj" means a Clark and West's (2007) reformulation of sample MSE has been applied
, and "NW" means robust Newey-West type estimator (c.f. Deng and Perron, 2008) for heteroskedastic errors has been used.
}
\description{
It calculates the SBar statistics for nested models with null hypothesis being the two models having equal predictive power following Pitarakis (2023).
There are in total four versions of SBar, based on the assumptions of variance (homo or hete) and residuals (original or adjusted).
All SBar statistics will be standarised to a standard N(0,1) normal distribution, and corresponding P values would be provided.
}
\examples{
e1<- rnorm(15);
e2<- rnorm(15);
temp1 <- Nested_Stats_S0(e1,e2,lam10=0.5,lam20=0.8)
temp1$S_lam10_lam20_adj_NW     #\S^0_T(lam10, lam^20) with CW adjustment and NW correction
temp1$pv_S_lam10_lam20_adj_NW  #P value of it
}
\references{
Pitarakis, J. Y. (2023). A novel approach to predictive accuracy testing in nested environments. Econometric Theory, 1-44.

Deng, A., & Perron, P. (2008). The limit distribution of the CUSUM of squares test under general mixing conditions. Econometric Theory, 24(3), 809-822.

Clark, T. E., & West, K. D. (2007). Approximately normal tests for equal predictive accuracy in nested models. Journal of econometrics, 138(1), 291-311.
}
\seealso{
\code{\link{Nested_Stats_S0}}
}
\author{
Rong Peng, \email{r.peng@soton.ac.uk}
}
