% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pstest.R
\name{pstest}
\alias{pstest}
\title{pstest: Tests for the Propensity Score}
\usage{
pstest(d, pscore, xpscore, pscore.model = NULL, model = "logit",
  w = "ind", dist = "Mammen", nboot = 1000, cores = 1,
  chunk = 1000)
}
\arguments{
\item{d}{a vector containing the binary treatment indicator.}

\item{pscore}{a vector containing the estimated propensity scores.}

\item{xpscore}{a matrix (or data frame) containing the covariates (and their
transformations) included in the propensity score
estimation. It should also include the constant term.}

\item{pscore.model}{in case you you set model="het.probit", pscore.model is the entire hetglm object.
Default for pscore.model is NULL.}

\item{model}{a description of the functional form (link function) used
to estimated propensity score. The alternatives are:
'logit' (default), 'probit', and het.probit}

\item{w}{a description of which weight function the projection is based on.
The alternatives are 'ind' (default), which set \eqn{w(q,u)=1(q<=u)},
'exp', which set \eqn{w(q,u)=exp(qu)}, 'logistic', which set
\eqn{w(q,u)=1/[1+exp(1-qu)]}, 'sin', which set \eqn{w(q,u)=sin(qu)}, and
'sincos', which set \eqn{w(q,u)=sin(qu)+cos(qu)}.}

\item{dist}{a description of which distribution to use during the bootstrap.
The alternatives are 'Mammen' (default), and 'Rademacher'.}

\item{nboot}{number of bootstrap replicates to perform. Default is 1,000.}

\item{cores}{number of cores to use during the bootstrap. Default is 1.
If cores is greater than 1, the bootstrap is conducted using
parLapply, instead of lapply type call.}

\item{chunk}{a value that determine the size of each 'tile'. Such argument is used
to split the original data into chunks, saving memory.
Default value is 1,000. If the \emph{pstest} function throw a
memory error, you should choose a smaller value for \emph{chunk}.}
}
\value{
a list containing the Kolmogorov-Smirnov and Cramer-von Mises test
       statistics for the null hypothesis of correctly specified propensity
       score model (kstest and cvmtest, respectively), and their associate
       bootstrapped p-values, pvks and pvcvm, respectively. All inputs are also
       returned.
}
\description{
\emph{pstest} computes Kolmogorov-Smirnov and Cramer-von Mises type tests
for the null hypothesis that a parametric model for the propensity score is
is correctly specified. For details of the testing procedure, see
Sant'Anna and Song (2016),'Specification Tests for the Propensity Score'.
}
\examples{
# Example based on simulation data
# Simulate vector of covariates
set.seed(1234)
x1 <- runif(100)
x2 <- rt(100, 5)
x3 <- rpois(100, 3)
# generate treatment status score based on Probit Specification
treat <- (x1 + x2 + x3 >= rnorm(100, 4, 5))
# estimate correctly specified propensity score based on Probit
pscore <- stats::glm(treat ~ x1 + x2 + x3, family = binomial(link = "probit"),
              x = TRUE)
# Test the correct specification of estimated propensity score, using
# the weight function 'ind', and bootstrap based on 'Mammen'.
pstest(d = pscore$y, pscore = pscore$fit, xpscore = pscore$x,
       model = "probit", w = "ind", dist = "Mammen")
# Alternatively, one can use the 'sin' weight function
pstest(d = pscore$y, pscore = pscore$fit, xpscore = pscore$x,
       model = "probit", w = "sin", dist = "Mammen")

}
\references{
Sant'Anna, Pedro H. C, and Song, Xiaojun (2019), \emph{Specification Tests for the Propensity Score},
      Journal of Econometrics, vol. 210 (2), p. 379-404.
}
