% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.ctmax.r
\name{calc.ctmax}
\alias{calc.ctmax}
\title{Calculate Cmax and Tmax}
\usage{
calc.ctmax(x, by = character(0), timevar = "time", depvar = "dv")
}
\arguments{
\item{x}{data.frame}

\item{by}{column names in x indicating grouping variables}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}
}
\value{
A dataset with estimates for the Cmax (maximum concentration)
and Tmax (time of first occurence of cmax) parameters: one observation per subject
}
\description{
Calculates Cmax and Tmax from raw data for each PK curve defined using \code{by}. \cr
}
\details{
Input dataset can contain all uncorrected data, including LOQ;
estimate first occurence of maximum concentration for each PK curve;
if all concentrations are NA, sets Cmax and Tmax also to NA.
}
\examples{
\donttest{
example(est.thalf)
ctmax <- x \%>\% calc.ctmax(by = 'subject')
ctmax \%>\% head
}
}
