% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch.R
\name{pitch.read}
\alias{pitch.read}
\title{pitch.read}
\usage{
pitch.read(fileNamePitch, encoding = "UTF-8")
}
\arguments{
\item{fileNamePitch}{file name of Pitch object}

\item{encoding}{File encoding (default: \code{"UTF-8"}), \code{"auto"} for auto-detect of Unicode encoding}
}
\value{
A Pitch object represents periodicity candidates as a function of time.

[ref: Praat help, https://www.fon.hum.uva.nl/praat/manual/Pitch.html]

\code{p$xmin} ... start time (seconds)

\code{p$xmax} ... end time (seconds)

\code{p$nx}   ... number of frames

\code{p$dx}   ... time step = frame duration (seconds)

\code{p$x1}   ... time associated with the first frame (seconds)

\code{p$t}    ... vector of time instances associated with all frames

\code{p$ceiling}        ... a frequency above which a candidate is considered voiceless (Hz)

\code{p$maxnCandidates} ... maximum number of candidates in frame

\code{p$frame[[1]]} to \code{p$frame[[p$nx]]} ... frames

\code{p$frame[[1]]$intensity}   ... intensity of the frame

\code{p$frame[[1]]$nCandidates} ... actual number of candidates in this frame

\code{p$frame[[1]]$frequency} ... vector of candidates' frequency (in Hz)

(for a voiced candidate), or \code{0} (for an unvoiced candidate)

\code{p$frame[[1]]$strength}  ... vector of degrees of periodicity of candidates (between \code{0} and \code{1})
}
\description{
Reads Pitch object from Praat.
Supported formats: text file, short text file.
}
\examples{
\dontrun{
p <- pitch.read('demo/sound.Pitch')
names(p)
p$nx
p$t[4]        # time instance of the 4th frame
p$frame[[4]]  # 4th frame: pitch candidates
p$frame[[4]]$frequency[2]
p$frame[[4]]$strength[2]
}
}
\seealso{
\code{\link{pitch.write}}, \code{\link{pitch.plot}}, \code{\link{pitch.cut}}, \code{\link{pitch.getPointIndexNearestTime}}, \code{\link{pt.read}}, \code{\link{tg.read}}, \code{\link{it.read}}, \code{\link{col.read}}
}
