% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cootrans_func.R
\name{cootrans}
\alias{cootrans}
\title{Tool for transforming local metric coordinates}
\usage{
cootrans(pair_matrix, pm_column, data_matrix, dm_column, checking = FALSE,
  checkplot = TRUE)
}
\arguments{
\item{pair_matrix}{data.frame or matrix with pairs of local and corresponding absolute coordinates (Minimum two!)}

\item{pm_column}{vector with numerical index of the columns in order: local x-value, local y-value, absolute x-value, absolute y-value}

\item{data_matrix}{data.frame with local x- and y-values which schould be transformed.}

\item{dm_column}{vector with numerical index of the columns in order: local x-value, local y-value.}

\item{checking}{boolean switch to turn on the checking ability. Default: FALSE. If TRUE showes combined coordinate plots with indexed points and alters return of function.}

\item{checkplot}{boolean switch to turn off the checking plot. Default: TRUE. Only matters if checking == TRUE.}
}
\value{
Original data.frame with additional columns containing the absolute x- and y-coordinates. In case of 'checking = TRUE' returns pair_matrix data.frame with additional columns of scale and rotation arc in degrees.
}
\description{
This function transforms local metric coordinates to absolute coordinates of referenced
systems by use of a two dimensional four parameter Helmert transformation. This function does
not cover the transformation of three dimensional points or transformation between two different
datums.
}
\examples{
coord_data <- data.frame(
 loc_x = c(1,3,1,3),
 loc_y = c(1,1,3,3),
 abs_x = c(107.1,107,104.9,105),
 abs_y = c(105.1,107,105.1,106.9)
)

data_table <- data.frame(
 x = c(1.5,1.2,1.6,2),
 y = c(1,5,2.1,2),
 type = c("flint","flint","pottery","bone")
)

new_frame <- cootrans(coord_data, c(1,2,3,4), data_table, c(1,2))

check_data <- cootrans(coord_data, c(1,2,3,4), data_table, c(1,2), checking = TRUE)

}
