% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XL-class.R
\name{xl}
\alias{xl}
\title{Excess of Loss Treaty: User constructor function}
\usage{
xl(ded = Inf, lim = Inf, aal = Inf, aad = Inf, prm = 0,
  rns = "none", ptf = "all")
}
\arguments{
\item{ded}{Numeric. Deductible amount of the treaty. Should be superior to 0.}

\item{lim}{Numeric. Limit amount for the treaty. Should be superior to 0. May be equal to \code{Inf}.}

\item{aal}{Numeric. Annual Aggregate Deductible amount of the treaty. Should be superior to 0.}

\item{aad}{Numeric. Annual Aggregate Limit amount for the treaty. Should be superior to 0. May be equal to \code{Inf}.}

\item{prm}{Numeric. Premium rate, which represents the proportion of the premium given to the reinsurer as price for the treaty. Should be between 0 and 1.}

\item{rns}{Numeric vector. Reinstatement prices. Vector of lentgh equals to the number of reinstatements with each value equals the price of the reinstatement.}

\item{ptf}{Vector. List of portfolios on which the treaty is to be applied on. Default value set to all.}
}
\value{
An object of class \code{XL} (\code{\link{XL-class}}), initialized with the values given in input. Its basic methods are:
\itemize{
 \item{\code{show}}
}
}
\description{
\code{xl} defines an object of class \code{XL} (\code{\link{XL-class}}), which represents an Excess of Loss treaty.
}
\details{
Reinstatements are the number of time the limit can be reconstructed. The vector given for this parameter will be an indication of the price for each reinstatement. For example, a \code{rns} value of \code{c(0, 1)} will give one free reinstatement and one reinstatement paid 100\% of the premium before totally consuming the limit.
}
\examples{
treaty_1 <- xl(ded = 200000, lim = 20000, aad = 0,
               aal = 10000, prm = 0.01, rns = c(0, 1))
treaty_1

}
