% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifold.R
\name{Manifold}
\alias{Manifold}
\title{Abstract Class for Manifolds}
\description{
An \link[R6:R6Class]{R6::R6Class} object implementing the base \code{\link{Manifold}}
class. In other words, a topological space that locally resembles Euclidean
space near each point.
}
\examples{

## ------------------------------------------------
## Method `Manifold$belongs`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$belongs(diag(1, 3))
}

## ------------------------------------------------
## Method `Manifold$is_tangent`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$is_tangent(diag(1, 3))
}

## ------------------------------------------------
## Method `Manifold$to_tangent`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$to_tangent(diag(1, 3))
}

## ------------------------------------------------
## Method `Manifold$random_point`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  # spd3$random_point(10) # TO DO: uncomment when bug fixed in gs
}

## ------------------------------------------------
## Method `Manifold$regularize`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$regularize(diag(1, 3))
}

## ------------------------------------------------
## Method `Manifold$set_metric`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$metric
  spd3$set_metric(SPDMetricBuresWasserstein$new(n = 3))
  spd3$metric
}

## ------------------------------------------------
## Method `Manifold$random_tangent_vec`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$random_tangent_vec(diag(1, 3), 10)
}
}
\author{
Nina Miolane
}
\keyword{internal}
\section{Super class}{
\code{rgeomstats::PythonClass} -> \code{Manifold}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{shape}}{An integer vector specifying the shape of one element of the
manifold. Defaults to \code{NULL}.}

\item{\code{metric}}{A \link{RiemannianMetric} object specifying the metric to use on
the manifold. Defaults to \code{NULL}.}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{extrensic} or \code{intrinsic}. Dedaults to \code{intrinsic}.}

\item{\code{default_point_type}}{A string specifying the point type. Choices are
\code{vector} or \code{matrix}. It is automatically determined depending on the
manifold.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Manifold-new}{\code{Manifold$new()}}
\item \href{#method-Manifold-belongs}{\code{Manifold$belongs()}}
\item \href{#method-Manifold-is_tangent}{\code{Manifold$is_tangent()}}
\item \href{#method-Manifold-to_tangent}{\code{Manifold$to_tangent()}}
\item \href{#method-Manifold-random_point}{\code{Manifold$random_point()}}
\item \href{#method-Manifold-regularize}{\code{Manifold$regularize()}}
\item \href{#method-Manifold-set_metric}{\code{Manifold$set_metric()}}
\item \href{#method-Manifold-random_tangent_vec}{\code{Manifold$random_tangent_vec()}}
\item \href{#method-Manifold-clone}{\code{Manifold$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-new"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Manifold}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$new(
  dim,
  shape = NULL,
  metric = NULL,
  default_coords_type = "intrinsic",
  py_cls = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{shape}}{An integer vector specifying the shape of one element of the
manifold. Defaults to \code{NULL}.}

\item{\code{metric}}{A \code{\link{RiemannianMetric}} object specifying the metric to use
on the manifold. Defaults to \code{NULL}.}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{extrinsic} or \code{intrinsic}. Defaults to \code{intrinsic}.}

\item{\code{py_cls}}{A Python object of class \code{Manifold}. Defaults to \code{NULL} in
which case it is instantiated on the fly using the other input
arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Manifold}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-belongs"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-belongs}{}}}
\subsection{Method \code{belongs()}}{
Evaluates if a point belongs to the manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$belongs(point, atol = gs$backend$atol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times
\{\mathrm{dim}\}]} specifying one or more points to be checked.}

\item{\code{atol}}{A numeric value specifying the absolute tolerance for
checking. Defaults to \code{gs$backend$atol}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A boolean value or vector storing whether the corresponding
points belong to the manifold.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$belongs(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-is_tangent"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-is_tangent}{}}}
\subsection{Method \code{is_tangent()}}{
Checks whether a vector is tangent at a base point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$is_tangent(vector, base_point = NULL, atol = gs$backend$atol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vector}}{A numeric array of shape \eqn{[\dots \times
[\mathrm{dim}]]} specifying one or more vectors to be checked.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times
  [\mathrm{dim}]]} specifying one or more base points on the manifold.
Defaults to \code{NULL} in which case the identity is used.}

\item{\code{atol}}{A numeric value specifying the absolute tolerance for
checking. Defaults to \code{gs$backend$atol}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A boolean value or vector storing whether the corresponding
points are tangent to the manifold at corresponding base points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$is_tangent(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-to_tangent"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-to_tangent}{}}}
\subsection{Method \code{to_tangent()}}{
Projects a vector to a tangent space of the manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$to_tangent(vector, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vector}}{A numeric array of shape \eqn{[\dots \times
  [\mathrm{dim}]]} specifying one or more vectors to project on the
manifold.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times
  [\mathrm{dim}]]} specifying one or more base points on the manifold.
Defaults to \code{NULL} in which case the identity is used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{\mathrm{dim}\}]}
storing the corresponding projections onto the manifold at
corresponding base points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$to_tangent(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-random_point"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-random_point}{}}}
\subsection{Method \code{random_point()}}{
Samples random points on the manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$random_point(n_samples = 1, bound = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_samples}}{An integer value specifying the number of samples to be
drawn. Defaults to \code{1L}.}

\item{\code{bound}}{A numeric value specifying the bound of the interval in
which to sample for non-compact manifolds. Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If the manifold is compact, a uniform distribution is used.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{\mathrm{dim}\}]}
storing a sample of points on the manifold.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  # spd3$random_point(10) # TO DO: uncomment when bug fixed in gs
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-regularize"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-regularize}{}}}
\subsection{Method \code{regularize()}}{
Regularizes a point to the canonical representation for the
manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$regularize(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times
[\mathrm{dim}]]} specifying one or more points on the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the corresponding
regularized points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  A <- diag(1, 3)
  spd3$regularize(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-set_metric"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-set_metric}{}}}
\subsection{Method \code{set_metric()}}{
Sets the Riemannian Metric associated to the manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$set_metric(metric)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{An object of class \code{\link{RiemannianMetric}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \link{Manifold} class itself invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$metric
  spd3$set_metric(SPDMetricBuresWasserstein$new(n = 3))
  spd3$metric
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-random_tangent_vec"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-random_tangent_vec}{}}}
\subsection{Method \code{random_tangent_vec()}}{
Generates a random tangent vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$random_tangent_vec(base_point, n_samples = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times
\{\mathrm{dim}\}]} specifying one or more base points on the manifold.}

\item{\code{n_samples}}{An integer value specifying the number of samples to be
drawn. Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{\mathrm{dim}\}]}
storing a sample of vectors that are tangent to the manifold at
corresponding base points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$random_tangent_vec(diag(1, 3), 10)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Manifold-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Manifold-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Manifold$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
