% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{rockr.package_install}
\alias{rockr.package_install}
\title{Install a package in the R server}
\usage{
rockr.package_install(conn, name, ref = NULL, manager = "cran")
}
\arguments{
\item{conn}{A rockr connection object.}

\item{name}{The package name or identifier in the source code repository.}

\item{ref}{The branch/commit number of the source code repositories.}

\item{manager}{The package manager: cran, github (gh), bioconductor (bioc).}
}
\value{
Void
}
\description{
Install a package in the R server. Package can be in different kind of
repositories: CRAN, GitHub or Bioconductor.
}
\examples{
\dontrun{
conn <- rockr.connect(username='administrator', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.package_install(conn, 'tibble')
}
}
\seealso{
Other administration functions: 
\code{\link{rockr.log}()},
\code{\link{rockr.package_rm}()},
\code{\link{rockr.packages_datashield}()},
\code{\link{rockr.packages_rm}()},
\code{\link{rockr.packages}()},
\code{\link{rockr.package}()},
\code{\link{rockr.restart}()},
\code{\link{rockr.session_switch}()},
\code{\link{rockr.sessions}()},
\code{\link{rockr.session}()},
\code{\link{rockr.start}()},
\code{\link{rockr.status}()},
\code{\link{rockr.stop}()},
\code{\link{rockr.version}()}
}
\concept{administration functions}
