% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_birth_month.R
\name{get_birth_month}
\alias{get_birth_month}
\title{Extract the Month of Birth from the Personal Numeric Code}
\usage{
get_birth_month(cnp)
}
\arguments{
\item{cnp}{a 13-digit number (or a vector of 13-digit numbers) representing
the Personal Numeric Code - CNP}
}
\value{
a numeric vector representing the month of birth
}
\description{
This function extracts the month of birth starting from the \code{"LL"} component.
}
\examples{
get_birth_month(1940616346114)
get_birth_month(7041218318525)
cnps <- c(5201206346491, 1940616346114, 7041218318525, 6201206018078)
get_birth_month(cnps)
get_birth_month(c(5201206346491, 1940616346114, 7041218318525, NA))
}
