% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.rotationForest.R
\name{predict.rotationForest}
\alias{predict.rotationForest}
\title{Predict method for rotationForest objects}
\usage{
\method{predict}{rotationForest}(object, newdata, all = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{rotationForest}}

\item{newdata}{A data frame with the same predictors as in the training data.}

\item{all}{Return the predictions per tree instead of the average.}

\item{...}{Not used currently.}
}
\value{
A vector containing the response scores.
}
\description{
Prediction of new data using rotationForest.
}
\examples{
data(iris)
y <- as.factor(ifelse(iris$Species[1:100]=="setosa",0,1))
x <- iris[1:100,-5]
rF <- rotationForest(x,y)
predict(object=rF,newdata=x)
}
\references{
Rodriguez, J.J., Kuncheva, L.I., 2006. Rotation forest: A new classifier ensemble method. IEEE Trans. Pattern Anal. Mach. Intell. 28, 1619-1630. doi:10.1109/TPAMI.2006.211
}
\seealso{
\code{\link{rotationForest}}
}
\author{
Michel Ballings and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
\keyword{classification}
