% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{checkAndReturnsEsMinParameterSide}
\alias{checkAndReturnsEsMinParameterSide}
\title{Checks consistency between the sided of the hypothesis and the  minimal clinically relevant effect size
or safe test defining parameter. Throws an error if the one-sided hypothesis is incongruent with the}
\usage{
checkAndReturnsEsMinParameterSide(
  paramToCheck,
  alternative = c("twoSided", "greater", "less"),
  esMinName = c("noName", "meanDiffMin", "phiS", "deltaMin", "deltaS", "hrMin", "thetaS",
    "deltaTrue"),
  paramDomain = NULL
)
}
\arguments{
\item{paramToCheck}{numeric. Either a named safe test defining parameter such as phiS, or thetaS, or a
minimal clinically relevant effect size called with a non-null esMinName name}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "twoSided" (default),
"greater" or "less".}

\item{esMinName}{provides the name of the effect size. Either "meanDiffMin" for the z-test, "deltaMin" for
the t-test, or "hrMin" for the logrank test}

\item{paramDomain}{Domain of the paramToCheck, typically, positiveNumbers. Default \code{NULL}}
}
\value{
paramToCheck after checking, perhaps with a change in sign
}
\description{
Checks consistency between the sided of the hypothesis and the  minimal clinically relevant effect size
or safe test defining parameter. Throws an error if the one-sided hypothesis is incongruent with the
}
