% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scqe.2csumm}
\alias{scqe.2csumm}
\title{Stability controlled quasi-experiment (scqe) for 1 cohort case,
summary statistics}
\usage{
scqe.2csumm(
  untr_pre,
  untr_post,
  tr_post,
  tr_pre,
  Y_tr_post,
  Y_untr_post,
  Y_tr_pre,
  Y_untr_pre,
  min_delta,
  max_delta,
  delta,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{untr_pre}{Integer number of untreated patients in the first cohort if
applicable (summary statistics input) (T=0).}

\item{untr_post}{Integer number of untreated patients in the second cohort
if applicable (summary statistics input) (T=1).}

\item{tr_post}{Integer number of treated patients in the second cohort if
applicable (summary statistics input) (T=1).}

\item{tr_pre}{Integer number of treated patients in the first cohort if
applicable (summary statistics input) (T=0).}

\item{Y_tr_post}{Outcome for patients who received treatment at time T=1
(summary statistics input).}

\item{Y_untr_post}{Outcome for patients who did not receive treatment at
time T=1 (summary statistics input).}

\item{Y_tr_pre}{Outcome for patients who did receive treatment at time T=0
(summary statistics input).}

\item{Y_untr_pre}{Outcome for patients who did not receive treatment at time
T=0 (summary statistics input).}

\item{min_delta}{Minimum delta. Optional, not used if \code{delta} is supplied.}

\item{max_delta}{Maximum delta. Optional, not used if \code{delta} is supplied.}

\item{delta}{Numeric scalar or numeric vector of possible values for change
in average non-treatment outcome between cohorts (if applicable).}

\item{alpha}{Numeric alpha for confidence interval (default is alpha=.05).}

\item{...}{Extra optional arguments.}
}
\value{
scqe object of class "scqe." Returns results table for the 2 cohort,
summary statistics case.
}
\description{
This function returns the scqe estimates and confidence intervals for the
2 cohort case when the user inputs only summary statistics.
}
\examples{
# Two cohorts, summary data only
scqe_2cohort_sum <- scqe(untr_pre = 200,untr_post = 150,tr_post = 50,
                         tr_pre=0, Y_tr_post = 20, Y_untr_post = 1,
                         Y_tr_pre=0, Y_untr_pre = 5,min_delta = 0.1,
                         max_delta = 1)
plot(scqe_2cohort_sum)
summary(scqe_2cohort_sum)

}
