% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{reshape_adates}
\alias{reshape_adates}
\title{Reshape format of all dates (full and partial)}
\usage{
reshape_adates(dates)
}
\arguments{
\item{dates}{a character vector of full and/or partial dates}
}
\value{
a character vector of full and/or partial dates in the format
\code{"YYYY-MM-DD"}
}
\description{
Re-arranges full and partial dates in the general form of \code{"MM/DD/YYYY"} to
the ISO 8601 format (\code{"YYYY-MM-DD"}). This function is appropriate for
vectors with mixed full and partial dates because it will not convert the
partial dates to \code{NA} which would occur if you used
\code{as.Date("02/UN/2017", format = "\%m/\%d/\%Y")}.
}
\details{
The date component separator in the input vector \code{dates} can be any
character.
}
\examples{
dates <- c("02/05/2017", "UN/UN/2017", "02-05-2017", NA)
reshape_adates(dates)

}
\seealso{
\code{\link[=reshape_pdates]{reshape_pdates()}}, \code{\link[=impute_pdates]{impute_pdates()}}, \code{\link[=trim_dates]{trim_dates()}},
\code{vignette("Dates")}
}
