% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isSeasonal.R
\name{isSeasonal}
\alias{isSeasonal}
\title{Testing the seasonality of series}
\usage{
isSeasonal(x, test = "combined", freq = NA)
}
\arguments{
\item{x}{time series}

\item{test}{Test to be used}

\item{freq}{Frequency of the time series}
}
\description{
Using a user-chosen seasonality test, the seasonality of a time series is assessed and a boolean value is returned.
}
\details{
By default, the combined-test is used to assess the seasonality of a time series and returns a boolean. Alternatively, the QS test (test='qs'), Friedman test (test='fried'), Kruskall-Wallis (test='kw'), F-test on seasonal dummies (test='seasdum') or the Welch test (test='welch') can be used.
}
\examples{
isSeasonal(ts(rnorm(120, 10,10), frequency=12))
isSeasonal(ts(rnorm(1200, 10,10), frequency=7))
}
\references{
Webel, K. and Ollech, D. (2019). An overall seasonality test. Deutsche Bundesbank's Discussion Paper series.
}
\author{
Daniel Ollech
}
