% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_MVN_X.R
\name{sim_MVN_X}
\alias{sim_MVN_X}
\title{Simulate Spatially Correlated MVN Data}
\usage{
sim_MVN_X(
  N,
  mu = 0,
  L = NULL,
  R = NULL,
  S = NULL,
  Q = NULL,
  use.spam = FALSE,
  use.MASS = FALSE,
  X.categorical = FALSE,
  X.num.categories = 2,
  X.category.type = "percentile",
  X.percentiles = NULL,
  X.manual.thresh = NULL,
  X.cat.names = NULL
)
}
\arguments{
\item{N}{The number of draws to take from MVN; i.e., the number of subjects.}

\item{mu}{One of the following:
\itemize{
   \item A single scalar value for common mean.
   \item A vector of length \code{nrow(R)} (equivalently \code{nrow(R)})
    containing means for the MVN.
}}

\item{L, R}{\code{L} and \code{R} are lower and upper triangular matrices, 
respectively, and are the Cholesky factor(s) of the desired covariance 
matrix for the MVN. Obtain \code{L} or \code{R} via \code{chol_s2Dp()} 
with settings \code{triangle = "lower"} or \code{triangle = "upper"}, 
respectively. Specify either \code{L} or \code{R}, but NOT both.}

\item{S, Q}{A covariance or precision matrix respectively. These are for 
use with \code{spam}, and can be extracted from output of 
\code{\link[sim2Dpredictr]{chol_s2Dp}} after choosing 
\code{return.cov = TRUE} or \code{return.prec = TRUE}, respectively.}

\item{use.spam}{Logical. If \code{use.spam = TRUE} then use tools from the
R package \code{spam}; otherwise, base R functions are employed. For large
dimension MVN with sparse correlation structure, \code{spam} is 
recommended; otherwise, base R may be faster. Defaults to \code{FALSE}.
Requires either the covariance matrix \code{S} or precision matrix, 
\code{Q}, that corresponds to the Cholesky factor.}

\item{use.MASS}{Logical. When \code{TRUE} draws X from MVN using 
\code{mvrnorm} from \code{MASS}. Note that this requires specification of
the covariance matrix, \code{S}. Specifying the precision matrix instead 
may slow down the process for large dimensions. Recommended to use 
\code{spam} to generate draws when specifying a precision matrix, \code{Q}.}

\item{X.categorical}{Default is \code{X.categorical = FALSE}. If
\code{X.categorical = TRUE} then thresholds are applied to categorize
each predictor/image value.}

\item{X.num.categories}{A scalar value denoting the number of categories
in which to divide the data.}

\item{X.category.type}{Tells R how to categorize the data. Options are
\code{X.category.type = c("percentile", "manual")}.
If \code{X.category.type = "percentile"} then the data are divided into
percentiles based on \code{X.num.categories}; e.g. if 
\code{X.num.categories = 4} then the values are divided into quartiles, 
and values in Q1 equal 0, between Q1 and Q2 equal 1, between Q2 and Q3 
equal 2, and greater than Q3 equal 3. 
If \code{X.category.type = "manual"} then specify the cutoff points with
\code{X.manual.thresh}.}

\item{X.percentiles}{A vector of percentiles to be used in thresholding 
when \code{X.categorical = TRUE} and \code{X.category.type = "percentile"}.
The length of this vector should equal the number of categories minus one,
and all values should be between zero and one.}

\item{X.manual.thresh}{A vector containing the thresholds for categorizing
the values; e.g. if \code{X.num.categories = 4} and 
\code{X.manual.thresh = c(-3, 1, 17)}, then values less than -3 are set to
0, equal or greater than -3 and less than 1 are set to 1, equal or greater
than 1 but less than 17 are set to 2, and equal or greater than 17 are set
to 3. Note that \code{length(X.manual.thresh)} must always equal 
\code{X.num.categories - 1}.}

\item{X.cat.names}{A vector of category names. If \code{X.cat.names = NULL}
then the initial integers assigned are left as the values; the names in
\code{X.cat.names} are assigned in ascending order.}
}
\value{
Matrix of dimension \code{N} x \code{(nrow(L))} (or equivalently
\code{N} x \code{(nrow(R))}) where each row is draw from MVN, and each 
column represents a different "variable"; e.g. location in an image.
}
\description{
Takes N draws from a Multivariate Normal (MVN) distribution using either
base R or the R package \code{spam}. This function requires the Cholesky
decomposition of the desired covariance matrix.
}
\note{
This function requires the Cholesky decomposition of the desired 
covariance matrix for the MVN; this allows for using this function in 
simulating multiple datasets of \code{N} MVN draws while only taking the
Cholesky decomposition of the covariance matrix once.
}
\examples{
## verify MVN with base R
set.seed(732)
Lex <- chol_s2Dp(corr.structure = "ar1",
                 im.res = c(3, 3), 
                 rho = 0.25,
                 sigma = 1, 
                 use.spam = FALSE, 
                 corr.min = 0.02,
                 triangle = "lower", 
                 return.cov = TRUE)
XbR = sim_MVN_X(N = 1000, mu = 0, L = Lex$L)

apply(XbR, 2, mean)
cov(XbR)
Lex$S

## verify MVN with \code{spam}
set.seed(472)
Rex <- chol_s2Dp(im.res = c(3, 3), matrix.type = "prec",
                use.spam = TRUE, neighborhood = "ar1",
                triangle = "upper", return.prec = TRUE)

Xspam = sim_MVN_X(N = 1000, mu = 0, R = Rex$R, Q = Rex$Q)

apply(Xspam, 2, mean)
solve(cov(Xspam))
as.matrix(Rex$Q)

## Categories
set.seed(832)
Xtest <- sim_MVN_X(N = 30, mu = 0, L = Lex$L,
                   X.categorical = TRUE,
                   X.num.categories = 3,
                   X.category.type = "percentile",
                   X.cat.names = c("A", "B", "C"))
Xtest

}
\references{
\insertRef{spam}{sim2Dpredictr}

\insertRef{Ripley:1987}{sim2Dpredictr}

\insertRef{Rue:2001}{sim2Dpredictr}
}
