% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsample.R
\name{upsample}
\alias{upsample}
\title{Upsample a wave}
\usage{
upsample(wave, upsample.rate, method = "basic")
}
\arguments{
\item{wave}{Wave object to upsample.}

\item{upsample.rate}{The sample rate to upsample to.}

\item{method}{"basic" for linear, or a function to interpolate NAs in a vector}
}
\value{
A resampled Wave object
}
\description{
Used to upsample a Wave object. The upsampled sample rate must be an natural multiple
of the current sample rate.
}
\examples{
wave <- tuneR::sine(4000, samp.rate=44100)
wave2 <- upsample(wave, 88200)

}
