% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust.grouping.R
\name{hclust.grouping}
\alias{hclust.grouping}
\title{Grouping with hierarchical clustering (used in the PeakGrouper function)}
\usage{
hclust.grouping(
  current.peaks,
  min.samp.grp = 1,
  max.dupli.prop = 0.25,
  maxClust = 10,
  linkage = "average"
)
}
\arguments{
\item{current.peaks}{A number of neighbouring peaks to be grouped.}

\item{min.samp.grp}{The minimal amount of samples needed to form a group.}

\item{max.dupli.prop}{The maximal duplication proportion allowed for a group to be considered a single group.}

\item{maxClust}{The maximum number of clusters (depth of the tree).}

\item{linkage}{The linkage to be used in the hierarchical clustering. See the 'method' argument in \link[stats]{hclust}.}
}
\value{
Returns a data frame with grouped peaks.
}
\description{
Internal function in the PeakGrouper function for generating the hierarchical clustering tree and cutting it.
}
\seealso{
\code{\link{PeakGrouper}}
}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
