#' Pokemon Go Users
#'
#' Demographic information of a population of possible Pokemon Go users.
#'
#'
#' @format A data frame with 999 rows and 5 variables:
#' \describe{
#'   \item{Use}{\code{Y} if the individual used the app, \code{N} otherwise}
#'   \item{Age}{\code{>30} if the individual is older than 30,
#'               \code{<=30} otherwise}
#'   \item{Degree}{\code{Yes} if the individual completed a Higher
#'                 Education degree, \code{No} otherwise}
#'   \item{Gender}{\code{Male} or \code{Female}}
#'   \item{Activity}{\code{Yes} if the individual was physically active
#'                   (i.e. had a walk longer than 30 mins, went for a run or
#'                   had a bike ride to get some exercise) in the past week
#'                   before the experiment, \code{No} otherwise}
#' }
#'
#' @source \url{https://osf.io/xy5g6/}
#' @references Gabbiadini, Alessandro, Christina Sagioglou, and Tobias Greitemeyer.
#' "Does Pokémon Go lead to a more physically active life style?."
#'  *Computers in Human Behavior* 84 (2018): 258-263.
"Pokemon"

#' PhD Students Publications
#'
#' Number of publications of 915 PhD biochemistry students
#' during the 1950’s and 1960’s.
#'
#'
#' @format A data frame with 915 rows and 6 variables:
#' \describe{
#'   \item{Articles}{Number of articles during the last 3 years of PhD: either
#'                   \code{0}, \code{1-2} or \code{>2}.}
#'   \item{Gender}{\code{male} or \code{female}.}
#'   \item{Kids}{\code{yes} if the student has at least one kid 5 or younger,
#'               \code{no} otherwise.}
#'   \item{Married}{\code{yes} or \code{no}.}
#'   \item{Mentor}{Number of publications of the student's mentor:
#'                \code{low} between 0 and 3, \code{medium} between 4 and 10,
#'                \code{high} otherwise.}
#'   \item{Prestige}{\code{low} if the student is at a low-prestige university,
#'         \code{high} otherwise.}
#' }
#'
#' @source The data has been modified from the \code{Rchoice} package.
#' @references Long, J. S. (1990). The origins of sex differences in science.
#'  *Social Forces*, 68(4), 1297-1316.
"PhDArticles"

#' Asym dataset
#'
#' Artificial dataset with observations from four variables
#' having a non-symmetrical conditional independence structure.
#'
#' @format A data frame with 1000 observations of 4 binary variables.
#'
#' @source The data has been generated by Federico Carli \email{carli@dima.unige}.
"Asym"

#' Hospital trajectories
#'
#' @description Generated dataset with observations from five variables (SEX, AGE,
#' ICU, RSP, OUT) describing imaginary patients' trajectories
#' in a hospital.
#'
#'
#' @format A data frame with 10000 observations of 5 variables.
#'
#' @source The data has been generated with the code in the Examples section.
#'
#' @example data-raw/trajectories.R
"trajectories"

#' Trajectories of hospitalized SARS-CoV-2 patients
#'
#' @description Dataset with observations from four variables (Sex, Age,
#' ICU, death) for 10000 simulated SARS-CoV-2 hospital patients.
#'
#' @details The data are simulated from an event tree where conditional
#' probabilities for ICU and death are taken from the results of
#' Lefrancq et al. (2021).
#' Lefrancq et al. (2021) estimated such probabilities from data
#' on patients, recorded in the
#' SI-VIC database, who started their hospitalization between
#' 13 March and 30 November 2020.
#'
#'
#' @format A data frame with 10000 observations of 4 variables.
#' The variables and their levels are as follows:
#' - Sex: Female, Male
#' - Age: 0-39, 40-49, 50-59, 60-69, 70-79, 80+
#' - ICU: yes, no
#' - death: yes, no
#'
#' @source The data has been generated with the code in the Examples section.
#'         Conditional probabilities were copied from the tables in the
#'         Supplementary materials of Lefrancq et al. (2021).
#'         Marginal probabilities of gender and
#'         probabilities of age given gender were instead
#'         obtained from the linked GitHub repository
#'         \url{https://github.com/noemielefrancq/Evolution-Outcomes-COVID19-France}.
#' @references
#' Leonelli, M. and Varando, G. (2023).
#' Context-Specific Causal Discovery for Categorical Data Using Staged Trees.
#' *Proceedings of The 26th International Conference on Artificial Intelligence and Statistics*, in *Proceedings of Machine Learning Research*
#' 206:8871-8888 Available from https://proceedings.mlr.press/v206/leonelli23a.html.
#'
#' Lefrancq N., Paireau J., Hozé N., Courtejoie N., Yazdanpanah Y., Bouadma L. (2021).
#' Evolution of outcomes for patients hospitalised during the first 9 months of
#' the SARS-CoV-2 pandemic in France: A retrospective national surveillance
#' data analysis.
#' *The Lancet Regional Health - Europe*, 5:100087.
#' @example data-raw/covid_patients.R
"covid_patients"
