% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova2way.R
\name{anova2way}
\alias{anova2way}
\title{Two-Way ANOVA}
\usage{
anova2way(k =2 , j = 2, n,  mean = 0, sigma = 1,
          coefvar = NULL, method = c("Tukey", "LSD", "Dunnett", "Bonferroni", "Scheffe"),
          conf.level = 0.95, dec = 2)
}
\arguments{
\item{k}{number of levels Factor I. By default k=2.}

\item{j}{number of levels Factor II. By default j=2.}

\item{n}{number of elements in each group (k,j).}

\item{mean}{vector of means.}

\item{sigma}{vector of standard deviations.}

\item{coefvar}{an optional vector of coefficients of variation.}

\item{method}{post-hoc method applied. There are five possible choices: ``\code{Tukey}``, ``\code{LSD}``, ``\code{Dunnett}``, ``\code{Bonferroni}``, ``\code{Scheffe}``. Can be specified just the initial letter.}

\item{conf.level}{confidence level of the interval.}

\item{dec}{number of decimals for observations.}
}
\value{
A list containing the following components:
\itemize{

 \item \code{Data}: a data frame containing the samples created.


 \item \code{Size.effect}: size effect for each factor and interaction.

 \item \code{Significance/Test Post-Hoc}: significance for each factor and interaction and test Post-Hoc for each factor.

}
}
\description{
\code{anova2way} returns multivariate data in order to compute analysis of variance with 2 factors.
}
\examples{

anova2way(k=3, j=2, n=c(3,4,4,5,5,3), mean = c(1,4,2.5,5,6,3.75), sigma = c(1,1.5))

}
