% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{SoftwareSession}
\alias{SoftwareSession}
\title{Definition of a compute session, including its software and compute resource requirements and status.}
\usage{
SoftwareSession(
  alternateNames,
  clientsLimit,
  clientsRequest,
  cpuLimit,
  cpuRequest,
  dateEnd,
  dateStart,
  description,
  durationLimit,
  durationRequest,
  environment,
  id,
  identifiers,
  images,
  memoryLimit,
  memoryRequest,
  meta,
  name,
  networkTransferLimit,
  networkTransferRequest,
  status,
  timeoutLimit,
  timeoutRequest,
  url,
  volumeMounts
)
}
\arguments{
\item{alternateNames}{Alternate names (aliases) for the item.}

\item{clientsLimit}{The maximum number of concurrent clients the session is limited to.}

\item{clientsRequest}{The maximum number of concurrent clients requested for the session.}

\item{cpuLimit}{The amount of CPU the session is limited to.}

\item{cpuRequest}{The amount of CPU requested for the session.}

\item{dateEnd}{The date-time that the session ended.}

\item{dateStart}{The date-time that the session began.}

\item{description}{A description of the item.}

\item{durationLimit}{The maximum duration (seconds) the session is limited to.}

\item{durationRequest}{The maximum duration (seconds) requested for the session.}

\item{environment}{The software environment to execute this session in.}

\item{id}{The identifier for this item.}

\item{identifiers}{Any kind of identifier for any kind of Thing.}

\item{images}{Images of the item.}

\item{memoryLimit}{The amount of memory that the session is limited to.}

\item{memoryRequest}{The amount of memory requested for the session.}

\item{meta}{Metadata associated with this item.}

\item{name}{The name of the item.}

\item{networkTransferLimit}{The amount of network data transfer (GiB) that the session is limited to.}

\item{networkTransferRequest}{The amount of network data transfer (GiB) requested for the session.}

\item{status}{The status of the session (starting, stopped, etc).}

\item{timeoutLimit}{The inactivity timeout (seconds) the session is limited to.}

\item{timeoutRequest}{The inactivity timeout (seconds) requested for the session.}

\item{url}{The URL of the item.}

\item{volumeMounts}{Volumes to mount in the session.}
}
\value{
A \code{list} of class \code{SoftwareSession}
}
\description{
Definition of a compute session, including its software and compute resource requirements and status.
}
\seealso{
\code{\link{Thing}}
}
