% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{v2m}
\alias{v2m}
\title{(Atomic) Vector to Matrix}
\usage{
v2m(v, along = 2, rtn.dim.nm = NULL, check = TRUE)
}
\arguments{
\item{v}{(atomic) vector.}

\item{along}{numeric vector of length 1 that is equal to either 1 or 2 specifying
which dimension to bind \code{v} along. 1 means that \code{v} is binded along
rows (i.e., dimension 1) into a one row matrix. 2 means that \code{v} is binded
along columns (i.e., dimension 2) into a one column matrix.}

\item{rtn.dim.nm}{character vector of length 1 specifying what dimname to use
for the dimension of length 1 in the returned matrix. If \code{along} = 1,
then \code{rtn.dim.nm} will be the single rowname. If \code{along} = 2, then
\code{rtn.dim.nm} will be the single colname. If NULL, then the dimension of
length 1 has no dimname.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{v} is an atomic vector.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
matrix with typeof = \code{typeof(v)}. If \code{along} = 1, then the
dimensions = \code{c(1L, length(v))} and dimnames = \code{list(rtn.dim.nm, names(v))}.
If \code{along} = 2, then the dimensions = \code{c(length(v), 1L)} and dimnames =
\code{list(names(v), rtn.dim.nm)}.
}
\description{
\code{v2m} converts an (atomic) vector to a single row or single column matrix.
The matrix will be the same typeof as the atomic vector. The benefit of \code{v2m}
over \code{as.matrix.default} is that the dimension along which the vector is binded
can be either rows or columns, whereas in \code{as.matrix.default} it can only
be binded along a column.
}
\examples{
mtcars2 <- as.matrix(mtcars, rownames.force = TRUE) # to make sure dimnames stay in the example
v2m(mtcars2[, "mpg"])
identical(x = v2m(mtcars2[, "mpg"]),
   y = as.matrix(mtcars2[, "mpg"])) # default = as.matrix.default()
v2m(mtcars2[, "mpg"], along = 1)
identical(x = v2m(mtcars2[, "mpg"], along = 1),
   y = t(as.matrix(mtcars2[, "mpg"]))) # = t(as.matrix.default())
v2m(v = mtcars2[, "mpg"], rtn.dim.nm = "mpg")
}
