% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{d2ld}
\alias{d2ld}
\title{Data-Frame to List of Data-Frames}
\usage{
d2ld(
  d,
  by,
  keep.by = TRUE,
  drop = FALSE,
  sep = ".",
  lex.order = FALSE,
  check = TRUE
)
}
\arguments{
\item{d}{data.frame.}

\item{by}{character vector of colnames specifying the groups to split the data.frame
up by. Can be multiple colnames, which implicitly calls \code{interaction}.}

\item{keep.by}{logical vector of length 1 specifying whether the by columns should
be kept in the list of data.frames (TRUE) or removed (FALSE).}

\item{drop}{logical vector of length 1 specifying whether unused groups
from the \code{by} columns should be dropped (TRUE) or kept (FALSE). This only applies
when there are multiple \code{by} columns. \code{drop} = FALSE can then result in some
data.frames with \code{nrow} = 0. See \code{interaction} for details.}

\item{sep}{character vector of length 1 specifying the string used to separate
the group names. Only applicable with multiple \code{by} columns. See
\code{interaction} for details.}

\item{lex.order}{logical vector of length 1 specifying the order of the data.frames
in the list based on the groups in the \code{by} columns. This only applies
when there are multiple \code{by} columns. See \code{interaction} for details.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{d} is a data.frame and
\code{by} are colnames of \code{d}. This argument is available to allow flexibility
in whether the user values informative error messages (TRUE) vs. computational
efficiency (FALSE).}
}
\value{
list of data.frames split by the groups specified in the \code{by} columns.
The list names are the group names (with \code{sep} if there are multiple
\code{by} columns).
}
\description{
\code{d2ld} converts a data.frame to a list of data.frames. This is a simple call
to \code{split.data.frame} splitting the data.frame up by groups.
}
\examples{

# one grouping variable
d2ld(d = mtcars, by = "vs")
d2ld(d = mtcars, by = "gear")

# two grouping variables
d2ld(d = mtcars, by = c("vs","gear"))
d2ld(d = mtcars, by = c("vs","gear"), lex.order = TRUE)

# keep.by argument
d2ld(d = mtcars, by = "vs", keep.by = FALSE)
d2ld(d = mtcars, by = "gear", keep.by = FALSE)
d2ld(d = mtcars, by = c("vs","gear"), keep.by = FALSE)

}
