% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDHSdata.R
\name{getDHSdata}
\alias{getDHSdata}
\title{Download DHS survey data}
\usage{
getDHSdata(country, indicator = NULL, Recode = NULL, year)
}
\arguments{
\item{country}{Country name.}

\item{indicator}{Indicator of interests. Current list of supported indicators include: "womananemia", "ancvisit4+", "stunting", "wasting", "DPT3".}

\item{Recode}{Types of dhs Recode}

\item{year}{Year the survey conducted.}
}
\value{
This function returns the survey dataset that contains the indicator.
}
\description{
This function downloads DHS data for a particular country and survey.
}
\examples{
\dontrun{
# When indicator is known, download only the relevant file
dhsData <- getDHSdata(country = "Zambia",
                                 indicator = "ancvisit4+",
                                 year = 2018)

# When indicator is NULL or not recognized, download all files
dhsData <- getDHSdata(country = "Zambia",
                                 indicator = NULL,
                                 year = 2018)
names(dhsData)
}

}
\author{
Qianyu Dong
}
